/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.VariableName;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.filter.PassThrough;
import adams.data.spreadsheet.filter.TrainableSpreadSheetFilter;
import adams.event.VariableChangeEvent;
import adams.flow.core.Token;
import adams.flow.core.VariableMonitor;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetFilter
extends AbstractSpreadSheetTransformer
implements VariableMonitor {
    private static final long serialVersionUID = -4633161214275622241L;
    protected adams.data.spreadsheet.filter.SpreadSheetFilter m_Filter;
    protected VariableName m_VariableName;

    public String globalInfo() {
        return "Applies the specified spreadsheet filter to the data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new PassThrough());
        this.m_OptionManager.add("var-name", "variableName", (Object)new VariableName());
    }

    public void setFilter(adams.data.spreadsheet.filter.SpreadSheetFilter value) {
        this.m_Filter = value;
        this.reset();
    }

    public adams.data.spreadsheet.filter.SpreadSheetFilter getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to use for filtering the spreadsheet.";
    }

    public void setVariableName(VariableName value) {
        this.m_VariableName = value;
        this.reset();
    }

    public VariableName getVariableName() {
        return this.m_VariableName;
    }

    public String variableNameTipText() {
        return "The variable to monitor for resetting trainable filters.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"filter", (Object)this.m_Filter);
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"variableName", (Object)this.m_VariableName.paddedValue(), (String)", monitor: ");
        return result;
    }

    public void variableChanged(VariableChangeEvent e) {
        super.variableChanged(e);
        if ((e.getType() == VariableChangeEvent.Type.MODIFIED || e.getType() == VariableChangeEvent.Type.ADDED) && e.getName().equals(this.m_VariableName.getValue())) {
            if (this.m_Filter instanceof TrainableSpreadSheetFilter) {
                ((TrainableSpreadSheetFilter)this.m_Filter).resetFilter();
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Reset 'trainable filter'");
            }
        }
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        try {
            sheet = this.m_Filter.filter(sheet);
        }
        catch (Exception e) {
            result = this.handleException("Failed to filter spreadsheet!", e);
            sheet = null;
        }
        if (sheet != null) {
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }
}

