/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.data.spreadsheet.rowscore.AbstractRowScore;
import adams.data.spreadsheet.rowscore.RowStatistic;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;
import java.util.ArrayList;

public class SpreadSheetInsertRowScore
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = 9030574317512531337L;
    protected SpreadSheetColumnIndex m_Position;
    protected boolean m_After;
    protected String m_Header;
    protected AbstractRowScore m_Score;

    public String globalInfo() {
        return "Inserts a score column at a specific position into spreadsheets coming through.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Position = new SpreadSheetColumnIndex();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("position", "position", (Object)new SpreadSheetColumnIndex("last"));
        this.m_OptionManager.add("after", "after", (Object)true);
        this.m_OptionManager.add("header", "header", (Object)"Score-#");
        this.m_OptionManager.add("score", "score", (Object)new RowStatistic());
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"header", (Object)("'" + this.m_Header + "'"), (String)"header: ");
        result = QuickInfoHelper.hasVariable((OptionHandler)this, (String)"after") ? (String)result + ", at/after: " : (this.m_After ? (String)result + ", after: " : (String)result + ", at: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"position", (Object)((Object)this.m_Position));
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"score", (Object)((Object)this.m_Score), (String)", score: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy"));
        result = (String)result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setPosition(SpreadSheetColumnIndex value) {
        this.m_Position = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position where to insert the score column; " + this.m_Position.getExample();
    }

    public void setAfter(boolean value) {
        this.m_After = value;
        this.reset();
    }

    public boolean getAfter() {
        return this.m_After;
    }

    public String afterTipText() {
        return "If enabled, the score column is inserted after the position instead of at the position.";
    }

    public void setHeader(String value) {
        this.m_Header = value;
        this.reset();
    }

    public String getHeader() {
        return this.m_Header;
    }

    public String headerTipText() {
        return "The name of the score column; '#' is 1-based index for filled in score value, '$' is 1-based, absolute column index; Using a header definition of 'Att-1,Att-2,Att-3' with a size of 5 will give you: 'Score-#' -> 'Att-1,Att-2,Att-3,Score-1,Score-2', 'Score-$' -> 'Att-1,Att-2,Att-3,Score-4,Score-5'";
    }

    public void setScore(AbstractRowScore value) {
        this.m_Score = value;
        this.reset();
    }

    public AbstractRowScore getScore() {
        return this.m_Score;
    }

    public String scoreTipText() {
        return "The score algorithm to use.";
    }

    protected String doExecute() {
        int i;
        int row;
        String result = null;
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        ArrayList<Double[]> scores = new ArrayList<Double[]>();
        for (row = 0; row < sheetOld.getRowCount(); ++row) {
            scores.add(this.m_Score.calculateScore(sheetOld, row));
        }
        this.m_Position.setSpreadSheet(sheetOld);
        int pos = this.m_Position.getIntIndex();
        if (this.m_After) {
            ++pos;
        }
        SpreadSheet sheetNew = this.m_NoCopy ? sheetOld : sheetOld.getClone();
        int numScores = this.m_Score.getNumScores();
        int currPos = pos;
        for (i = 0; i < numScores; ++i) {
            String header = this.m_Header;
            header = header.replace("#", "" + i).replace("$", "" + (currPos + 1));
            sheetNew.insertColumn(currPos, header);
            ++currPos;
        }
        for (row = 0; row < sheetNew.getRowCount(); ++row) {
            Double[] score = (Double[])scores.get(row);
            if (score != null) {
                currPos = pos;
                for (i = 0; i < numScores; ++i) {
                    Cell cell = sheetNew.getCell(row, currPos);
                    if (cell != null) {
                        cell.setContent(score[i]);
                    }
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info(SpreadSheetUtils.getCellPosition((int)row, (int)currPos) + ": " + score + " " + (cell == null ? "failed to set" : "set"));
                    }
                    ++currPos;
                }
                continue;
            }
            if (!this.isLoggingEnabled()) continue;
            this.getLogger().info(SpreadSheetUtils.getCellPosition((int)row, (int)pos) + ": failed to calculate score");
        }
        scores.clear();
        this.m_OutputToken = new Token((Object)sheetNew);
        return result;
    }
}

