/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.ClassCrossReference;
import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.AbstractColumnFinder;
import adams.data.spreadsheet.columnfinder.ByName;
import adams.data.spreadsheet.columnfinder.Invert;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.SpreadSheetMergeActor;
import adams.flow.transformer.SpreadSheetMethodMerge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SpreadSheetMerge
extends AbstractTransformer
implements SpreadSheetMergeActor,
ClassCrossReference {
    private static final long serialVersionUID = 3363405805013155845L;
    protected boolean m_UsePrefix;
    protected boolean m_AddIndex;
    protected boolean m_Remove;
    protected String m_Prefix;
    protected String m_PrefixSeparator;
    protected String m_ExcludedAttributes;
    protected boolean m_InvertMatchingSense;
    protected String m_UniqueID;
    protected boolean m_KeepOnlySingleUniqueID;
    protected boolean m_Strict;
    protected List<String> m_UniqueIDAtts;

    public String globalInfo() {
        return "Merges two or more spreadsheets. The merge can be done by using a common key-column or by simply putting the spreadsheets side-by-side.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{SpreadSheetMethodMerge.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-prefix", "usePrefix", (Object)false);
        this.m_OptionManager.add("add-index", "addIndex", (Object)false);
        this.m_OptionManager.add("remove", "remove", (Object)false);
        this.m_OptionManager.add("prefix", "prefix", (Object)"dataset");
        this.m_OptionManager.add("prefix-separator", "prefixSeparator", (Object)"-");
        this.m_OptionManager.add("exclude-atts", "excludedAttributes", (Object)"");
        this.m_OptionManager.add("invert", "invertMatchingSense", (Object)false);
        this.m_OptionManager.add("unique-id", "uniqueID", (Object)"");
        this.m_OptionManager.add("keep-only-single-unique-id", "keepOnlySingleUniqueID", (Object)false);
        this.m_OptionManager.add("strict", "strict", (Object)false);
    }

    public void setRemove(boolean value) {
        this.m_Remove = value;
        this.reset();
    }

    public boolean getRemove() {
        return this.m_Remove;
    }

    public String removeTipText() {
        return "If true, only keep instances where data is available from each source.";
    }

    public void setUsePrefix(boolean value) {
        this.m_UsePrefix = value;
        this.reset();
    }

    public boolean getUsePrefix() {
        return this.m_UsePrefix;
    }

    public String usePrefixTipText() {
        return "Whether to prefix the attribute names of each dataset with an index and an optional string.";
    }

    public void setAddIndex(boolean value) {
        this.m_AddIndex = value;
        this.reset();
    }

    public boolean getAddIndex() {
        return this.m_AddIndex;
    }

    public String addIndexTipText() {
        return "Whether to add the index of the dataset to the prefix.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The optional prefix string to prefix the index number with (in case prefixes are used).";
    }

    public void setPrefixSeparator(String value) {
        this.m_PrefixSeparator = value;
        this.reset();
    }

    public String getPrefixSeparator() {
        return this.m_PrefixSeparator;
    }

    public String prefixSeparatorTipText() {
        return "The separator string between the generated prefix and the original attribute name.";
    }

    public void setExcludedAttributes(String value) {
        this.m_ExcludedAttributes = value;
        this.reset();
    }

    public String getExcludedAttributes() {
        return this.m_ExcludedAttributes;
    }

    public String excludedAttributesTipText() {
        return "The regular expression used on the attribute names, to determine whether an attribute should be excluded or not (matching sense can be inverted); leave empty to include all attributes.";
    }

    public void setInvertMatchingSense(boolean value) {
        this.m_InvertMatchingSense = value;
        this.reset();
    }

    public boolean getInvertMatchingSense() {
        return this.m_InvertMatchingSense;
    }

    public String invertMatchingSenseTipText() {
        return "Whether to invert the matching sense of excluding attributes, ie, the regular expression is used for including attributes.";
    }

    public void setUniqueID(String value) {
        this.m_UniqueID = value;
        this.reset();
    }

    public String getUniqueID() {
        return this.m_UniqueID;
    }

    public String uniqueIDTipText() {
        return "The name of the column used for uniquely identifying rows among the spreadsheets.";
    }

    public void setKeepOnlySingleUniqueID(boolean value) {
        this.m_KeepOnlySingleUniqueID = value;
        this.reset();
    }

    public boolean getKeepOnlySingleUniqueID() {
        return this.m_KeepOnlySingleUniqueID;
    }

    public String keepOnlySingleUniqueIDTipText() {
        return "If enabled, only a single instance of the unique ID attribute is kept.";
    }

    public void setStrict(boolean value) {
        this.m_Strict = value;
        this.reset();
    }

    public boolean getStrict() {
        return this.m_Strict;
    }

    public String strictTipText() {
        return "If enabled, ensures that IDs in unique ID column are truly unique.";
    }

    public String getQuickInfo() {
        String value;
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix, (String)"prefix: ");
        if (result == null) {
            result = "";
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"prefixSeparator", (Object)this.m_PrefixSeparator, (String)", separator: ")) != null) {
            result = (String)result + value;
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"excludedAttributes", (Object)this.m_ExcludedAttributes, (String)", excluded: ")) != null) {
            result = (String)result + value;
        }
        if ((value = QuickInfoHelper.toString((OptionHandler)this, (String)"uniqueID", (Object)this.m_UniqueID, (String)", unique: ")) != null) {
            result = (String)result + value;
        }
        if (((String)result).startsWith(", ")) {
            result = ((String)result).substring(2);
        }
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"addIndex", (boolean)this.m_AddIndex, (String)"index"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"usePrefix", (boolean)this.m_UsePrefix, (String)"prefix"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"invertMatchingSense", (boolean)this.m_InvertMatchingSense, (String)"invert"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"remove", (boolean)this.m_Remove, (String)"remove"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"keepOnlySingleUniqueID", (boolean)this.m_KeepOnlySingleUniqueID, (String)"single unique ID"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"strict", (boolean)this.m_Strict, (String)"strict"));
        result = (String)result + QuickInfoHelper.flatten(options);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet[].class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected SpreadSheet excludeAttributes(SpreadSheet sheet) {
        ByName byname = new ByName();
        byname.setRegExp(new BaseRegExp(this.m_ExcludedAttributes));
        AbstractColumnFinder finder = byname;
        if (this.m_InvertMatchingSense) {
            Invert invert = new Invert();
            invert.setColumnFinder(byname);
            finder = invert;
        }
        SpreadSheet result = AbstractColumnFinder.filter(sheet, finder);
        return result;
    }

    protected String createPrefix(int index) {
        if (!this.m_UsePrefix) {
            return "";
        }
        Object result = this.m_Prefix;
        if (this.m_AddIndex) {
            if (((String)result).length() > 0) {
                result = (String)result + this.m_PrefixSeparator;
            }
            result = (String)result + (index + 1);
        }
        if (((String)result).length() > 0 && !((String)result).endsWith(this.m_PrefixSeparator)) {
            result = (String)result + this.m_PrefixSeparator;
        }
        return result;
    }

    protected SpreadSheet prefixColumns(SpreadSheet inst, int index) {
        SpreadSheet result = inst.getClone();
        String prefix = this.createPrefix(index);
        HeaderRow row = result.getHeaderRow();
        for (int i = 0; i < result.getColumnCount(); ++i) {
            row.getCell(i).setContent(prefix + row.getCell(i).getContent());
        }
        return result;
    }

    protected SpreadSheet prepareData(SpreadSheet inst, int index) {
        SpreadSheet result = inst;
        if (this.m_KeepOnlySingleUniqueID && !this.m_UniqueID.isEmpty() && inst.getHeaderRow().indexOfContent(this.m_UniqueID) > -1 && index > 0) {
            this.m_UniqueIDAtts.add(this.createPrefix(index) + this.m_UniqueID);
        }
        if (this.m_ExcludedAttributes.length() > 0) {
            result = this.excludeAttributes(result);
        }
        if (this.m_UsePrefix) {
            result = this.prefixColumns(inst, index);
        }
        return result;
    }

    protected void updateIDs(int sheetIndex, SpreadSheet inst, HashSet ids) {
        int index = inst.getHeaderRow().indexOfContent(this.m_UniqueID);
        if (index == -1) {
            throw new IllegalStateException("Column '" + this.m_UniqueID + "' not found in spreadsheet #" + (sheetIndex + 1) + "!");
        }
        boolean numeric = inst.isNumeric(index);
        HashSet<Object> current = new HashSet<Object>();
        for (int i = 0; i < inst.getRowCount(); ++i) {
            if (!inst.hasCell(i, index) || inst.getCell(i, index).isMissing()) continue;
            Object id = numeric ? inst.getCell(i, index).toDouble() : inst.getCell(i, index).getContent();
            if (this.m_Strict && current.contains(id)) {
                throw new IllegalStateException("ID '" + id + "' is not unique in spreadsheet #" + (sheetIndex + 1) + "!");
            }
            current.add(id);
        }
        ids.addAll(current);
    }

    protected SpreadSheet merge(SpreadSheet[] orig, SpreadSheet[] sheets, HashSet ids) {
        int n;
        int i;
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Creating merged header...");
        }
        SpreadSheet result = orig[0].newInstance();
        int[] indexStart = new int[sheets.length];
        for (i = 0; i < sheets.length; ++i) {
            indexStart[i] = result.getColumnCount();
            for (n = 0; n < sheets[i].getColumnCount(); ++n) {
                result.getHeaderRow().addCell("" + result.getColumnCount()).setContent(sheets[i].getHeaderRow().getCell(n).getContent());
            }
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Filling with missing values...");
        }
        for (i = 0; i < ids.size(); ++i) {
            if (this.isStopped()) {
                return null;
            }
            if (this.isLoggingEnabled() && (i + 1) % 1000 == 0) {
                this.getLogger().info("" + (i + 1));
            }
            result.addRow();
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Sorting indices...");
        }
        ArrayList sortedIDs = new ArrayList(ids);
        Collections.sort(sortedIDs);
        HashMap<Integer, Integer> hashmap = new HashMap<Integer, Integer>();
        for (i = 0; i < sheets.length; ++i) {
            if (this.isStopped()) {
                return null;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Adding sheet #" + (i + 1));
            }
            String prefix = this.createPrefix(i);
            int colIndex = sheets[i].getHeaderRow().indexOfContent(prefix + this.m_UniqueID);
            boolean numeric = sheets[i].isNumeric(colIndex);
            for (n = 0; n < sheets[i].getRowCount(); ++n) {
                int index;
                if (this.isLoggingEnabled() && (n + 1) % 1000 == 0) {
                    this.getLogger().info("" + (n + 1));
                }
                if ((index = numeric ? Collections.binarySearch(sortedIDs, sheets[i].getCell(n, colIndex).toDouble()) : Collections.binarySearch(sortedIDs, sheets[i].getCell(n, colIndex).getContent())) < 0) {
                    throw new IllegalStateException("Failed to determine index for row #" + (n + 1) + " of sheet #" + (i + 1) + "!");
                }
                if (!hashmap.containsKey(index)) {
                    hashmap.put(index, 0);
                }
                hashmap.put(index, (Integer)hashmap.get(index) + 1);
                for (int m = 0; m < sheets[i].getColumnCount(); ++m) {
                    if (!sheets[i].hasCell(n, m) || sheets[i].getCell(n, m).isMissing()) continue;
                    result.getCell(index, indexStart[i] + m).assign(sheets[i].getCell(n, m));
                }
            }
        }
        if (this.getRemove()) {
            HashSet<Integer> hs = new HashSet<Integer>();
            for (Integer x : hashmap.keySet()) {
                if ((Integer)hashmap.get(x) == sheets.length) continue;
                hs.add(x);
            }
            ArrayList indices = new ArrayList(hs);
            Collections.sort(indices);
            Collections.reverse(indices);
            for (Integer ind : indices) {
                result.removeRow(ind.intValue());
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet[] orig = null;
        if (!(this.m_InputToken.getPayload() instanceof SpreadSheet[])) {
            throw new IllegalStateException("Unhandled input type: " + this.m_InputToken.getPayload().getClass());
        }
        orig = (SpreadSheet[])this.m_InputToken.getPayload();
        try {
            SpreadSheet output = null;
            if (this.m_UniqueID.length() == 0) {
                SpreadSheet[] sheet = new SpreadSheet[1];
                for (int i = 0; i < orig.length && !this.isStopped(); ++i) {
                    sheet[0] = this.prepareData(orig[i], i);
                    if (i == 0) {
                        output = sheet[0];
                        continue;
                    }
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Merging with spreadsheet #" + (i + 1));
                    }
                    output.mergeWith(sheet[0]);
                }
            } else {
                int i;
                this.m_UniqueIDAtts = new ArrayList<String>();
                int max = 0;
                for (i = 0; i < orig.length; ++i) {
                    max = Math.max(max, orig[i].getRowCount());
                }
                SpreadSheet[] sheet = new SpreadSheet[orig.length];
                HashSet ids = new HashSet(max);
                for (i = 0; i < orig.length && !this.isStopped(); ++i) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Updating IDs #" + (i + 1));
                    }
                    this.updateIDs(i, orig[i], ids);
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Preparing spreadsheet #" + (i + 1));
                    }
                    sheet[i] = this.prepareData(orig[i], i);
                }
                output = this.merge(orig, sheet, ids);
                if (this.m_UniqueIDAtts.size() > 0) {
                    block5: for (String col : this.m_UniqueIDAtts) {
                        for (i = output.getColumnCount() - 1; i >= 0; --i) {
                            if (!output.getColumnName(i).equals(col)) continue;
                            if (this.isLoggingEnabled()) {
                                this.getLogger().info("Removing unique ID column: #" + (i + 1) + "/" + col);
                            }
                            output.removeColumn(i);
                            continue block5;
                        }
                    }
                }
            }
            if (!this.isStopped()) {
                this.m_OutputToken = new Token(output);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to merge: ", e);
        }
        return result;
    }
}

