/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.transformer.AbstractArrayProvider;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import adams.flow.transformer.plotgenerator.XYPlotGenerator;

public class SpreadSheetPlotGenerator
extends AbstractArrayProvider {
    private static final long serialVersionUID = 1147935218531182101L;
    protected AbstractPlotGenerator m_Generator;

    public String globalInfo() {
        return "Outputs plot containers generated from a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new XYPlotGenerator());
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)((Object)this.m_Generator), (String)"generator: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (Object)(this.m_OutputArray ? "as array" : "one-by-one"), (String)", ");
        return result;
    }

    public String outputArrayTipText() {
        return "If enabled, the plot containers are output as an array rather than one-by-one.";
    }

    public void setGenerator(AbstractPlotGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractPlotGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The plot generator to use.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Queue.clear();
        try {
            this.m_Queue.addAll(this.m_Generator.generate(sheet));
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate plot containers with " + OptionUtils.getCommandLine((Object)((Object)this.m_Generator)), e);
        }
        return result;
    }

    protected Class getItemClass() {
        return SequencePlotterContainer.class;
    }
}

