/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Randomizable;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetView;
import adams.data.spreadsheet.SpreadSheetViewCreator;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import gnu.trove.list.array.TIntArrayList;
import java.util.Random;

public class SpreadSheetRandomSystematicSample
extends AbstractSpreadSheetTransformer
implements Randomizable,
SpreadSheetViewCreator {
    private static final long serialVersionUID = -1287490418250599839L;
    protected long m_Seed;
    protected int m_SampleSize;
    protected boolean m_CreateView;

    public String globalInfo() {
        return "Performs random systematic sampling on the rows of the incoming spreadsheet.\nDivides the rows into N blocks with N being the sample size. Then chooses a random starting position. Adds the row the output increments the position by the sample size. Position wraps around if output hasn't yet reached sample size.\nFor more information see:\nhttps://en.wikipedia.org/wiki/Systematic_sampling";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("seed", "seed", (Object)1L);
        this.m_OptionManager.add("sample-size", "sampleSize", (Object)10, (Number)1, null);
        this.m_OptionManager.add("create-view", "createView", (Object)false);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"sampleSize", (Object)this.m_SampleSize, (String)"size: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"createView", (boolean)this.m_CreateView, (String)", view only");
        if (value != null) {
            result = (String)result + value;
        }
        return result;
    }

    public void setSeed(long value) {
        this.m_Seed = value;
        this.reset();
    }

    public long getSeed() {
        return this.m_Seed;
    }

    public String seedTipText() {
        return "The seed for the randomization";
    }

    public void setSampleSize(int value) {
        this.m_SampleSize = value;
        this.reset();
    }

    public int getSampleSize() {
        return this.m_SampleSize;
    }

    public String sampleSizeTipText() {
        return "The size of the sample to use.";
    }

    @Override
    public void setCreateView(boolean value) {
        this.m_CreateView = value;
        this.reset();
    }

    @Override
    public boolean getCreateView() {
        return this.m_CreateView;
    }

    @Override
    public String createViewTipText() {
        return "If enabled, then only a view of the subset is created.";
    }

    protected String doExecute() {
        int inc;
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload(SpreadSheet.class);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("# rows: " + sheet.getRowCount());
        }
        if ((inc = sheet.getRowCount() / this.m_SampleSize) == 0) {
            result = "Less rows than sample size: " + sheet.getRowCount() + " < " + this.m_SampleSize;
        }
        if (this.isLoggingEnabled()) {
            this.getLogger().info("inc: " + inc);
        }
        if (result == null) {
            int i;
            TIntArrayList rowsOut = new TIntArrayList();
            Random rand = new Random(this.m_Seed);
            int pos = rand.nextInt(inc) - inc;
            if (this.isLoggingEnabled()) {
                this.getLogger().info("starting pos: " + pos);
            }
            for (i = 0; i < this.m_SampleSize; ++i) {
                if ((pos += inc) > sheet.getRowCount()) {
                    pos -= sheet.getRowCount();
                }
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("pos: " + pos);
                }
                rowsOut.add(pos);
            }
            if (this.m_CreateView) {
                this.m_OutputToken = new Token((Object)new SpreadSheetView(sheet, rowsOut.toArray(), null));
            } else {
                SpreadSheet sheetOut = sheet.getHeader();
                for (i = 0; i < rowsOut.size(); ++i) {
                    sheetOut.addRow().assign((Row)sheet.getRow(rowsOut.get(i)));
                }
                this.m_OutputToken = new Token((Object)sheetOut);
            }
        }
        return result;
    }
}

