/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetUnorderedRowRange;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetReorderRows
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = -6140158624456525670L;
    protected SpreadSheetUnorderedRowRange m_Order;

    public String globalInfo() {
        return "Reorders the rows in a spreadsheet according to a user-supplied order. Depending on whether you use a row multiple times or omit it, you effectively duplicate it or remove it from the final spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("order", "order", (Object)new SpreadSheetUnorderedRowRange("first-last"));
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"order", (Object)((Object)this.m_Order));
    }

    public void setOrder(SpreadSheetUnorderedRowRange value) {
        this.m_Order = value;
        this.reset();
    }

    public SpreadSheetUnorderedRowRange getOrder() {
        return this.m_Order;
    }

    public String orderTipText() {
        return "The new order for the rows";
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Order.isEmpty()) {
            result = "No new row order provided!";
        }
        if (result == null) {
            SpreadSheet input = (SpreadSheet)this.m_InputToken.getPayload();
            SpreadSheet output = input.getHeader();
            output.setDataRowClass(input.getDataRowClass());
            for (String comment : input.getComments()) {
                output.addComment(comment);
            }
            this.m_Order.setData(input);
            int[] indices = this.m_Order.getIntIndices();
            for (int i = 0; i < indices.length; ++i) {
                DataRow rowOld = input.getRow(indices[i]);
                DataRow rowNew = output.addRow();
                rowNew.assign((Row)rowOld);
            }
            this.m_OutputToken = new Token((Object)output);
        }
        return result;
    }
}

