/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.cellfinder.CellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.data.spreadsheet.cellfinder.CellRange;
import adams.data.spreadsheet.cellfinder.RowCellFinder;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;
import java.util.Iterator;

public class SpreadSheetSetCell
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = -6250232085303020849L;
    protected Range m_Row;
    protected SpreadSheetColumnRange m_Column;
    protected boolean m_UseFinder;
    protected CellFinder m_Finder;
    protected String m_Value;
    protected boolean m_ForceString;

    public String globalInfo() {
        return "Sets the value of the specified cells in a spreadsheet.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)new Range("1"));
        this.m_OptionManager.add("col", "column", (Object)new SpreadSheetColumnRange("1"));
        this.m_OptionManager.add("use-finder", "useFinder", (Object)false);
        this.m_OptionManager.add("finder", "finder", (Object)new CellRange());
        this.m_OptionManager.add("value", "value", (Object)"");
        this.m_OptionManager.add("force-string", "forceString", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_Row = new Range();
        this.m_Column = new SpreadSheetColumnRange();
    }

    public String getQuickInfo() {
        Object result;
        if (this.m_UseFinder) {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)"finder: ");
        } else {
            result = QuickInfoHelper.toString((OptionHandler)this, (String)"row", (Object)this.m_Row, (String)"row: ");
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)"/col: ");
        }
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)("'" + this.m_Value + "'"), (String)", value: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"forceString", (boolean)this.m_ForceString, (String)"force string", (String)", ");
        return result;
    }

    public void setRow(Range value) {
        this.m_Row = value;
        this.reset();
    }

    public Range getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row(s) of the cell(s) to set.";
    }

    public void setColumn(SpreadSheetColumnRange value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column(s) of the cell(s) to set";
    }

    public void setUseFinder(boolean value) {
        this.m_UseFinder = value;
        this.reset();
    }

    public boolean getUseFinder() {
        return this.m_UseFinder;
    }

    public String useFinderTipText() {
        return "If enabled, the value is set at the locations that the specified finder scheme determined.";
    }

    public void setFinder(CellFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public CellFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The column finder to use for identifying cells.";
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value to set in the cell(s).";
    }

    public void setForceString(boolean value) {
        this.m_ForceString = value;
        this.reset();
    }

    public boolean getForceString() {
        return this.m_ForceString;
    }

    public String forceStringTipText() {
        return "If enabled, the value is set as string, even if it resembles a number.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{SpreadSheet.class, Row.class};
    }

    @Override
    public Class[] generates() {
        return new Class[]{SpreadSheet.class, Row.class};
    }

    protected String doExecute() {
        String result = null;
        if (this.m_InputToken.getPayload() instanceof SpreadSheet) {
            SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
            if (!this.m_NoCopy) {
                sheet = sheet.getClone();
            }
            if (this.m_UseFinder) {
                Iterator<CellLocation> locs = this.m_Finder.findCells(sheet);
                while (locs.hasNext()) {
                    CellLocation loc = locs.next();
                    DataRow row = sheet.getRow(loc.getRow());
                    Cell cell = row.getCell(loc.getColumn());
                    if (cell == null) {
                        cell = row.addCell(loc.getColumn());
                    }
                    if (this.m_ForceString) {
                        cell.setContentAsString(this.m_Value);
                        continue;
                    }
                    cell.setContent(this.m_Value);
                }
                this.m_OutputToken = new Token((Object)sheet);
            } else {
                this.m_Row.setMax(sheet.getRowCount());
                this.m_Column.setSpreadSheet(sheet);
                int[] rows = this.m_Row.getIntIndices();
                int[] cols = this.m_Column.getIntIndices();
                if (rows.length == 0) {
                    result = "No row(s) selected? " + this.m_Row.getRange();
                    this.m_OutputToken = new Token((Object)sheet);
                } else if (cols.length == 0) {
                    result = "No column(s) selected? " + this.m_Column.getRange();
                    this.m_OutputToken = new Token((Object)sheet);
                } else {
                    for (int r : rows) {
                        for (int c : cols) {
                            DataRow row = sheet.getRow(r);
                            Cell cell = row.getCell(c);
                            if (cell == null) {
                                cell = row.addCell(c);
                            }
                            if (this.m_ForceString) {
                                cell.setContentAsString(this.m_Value);
                                continue;
                            }
                            cell.setContent(this.m_Value);
                        }
                    }
                    this.m_OutputToken = new Token((Object)sheet);
                }
            }
        } else if (this.m_InputToken.getPayload() instanceof Row) {
            Row row = (Row)this.m_InputToken.getPayload();
            if (!this.m_NoCopy) {
                row = row.getClone(row.getOwner());
            }
            if (this.m_UseFinder) {
                if (this.m_Finder instanceof RowCellFinder) {
                    Iterator<CellLocation> locs = ((RowCellFinder)this.m_Finder).findCells(row);
                    while (locs.hasNext()) {
                        CellLocation loc = locs.next();
                        Cell cell = row.getCell(loc.getColumn());
                        if (cell == null) {
                            cell = row.addCell(loc.getColumn());
                        }
                        if (this.m_ForceString) {
                            cell.setContentAsString(this.m_Value);
                            continue;
                        }
                        cell.setContent(this.m_Value);
                    }
                    this.m_OutputToken = new Token((Object)row);
                } else {
                    result = "Finder cannot handle rows by themselves (does not implement " + Utils.classToString(RowCellFinder.class) + ")";
                    this.m_OutputToken = new Token((Object)row);
                }
            } else {
                this.m_Column.setSpreadSheet(row.getOwner());
                int[] cols = this.m_Column.getIntIndices();
                if (cols.length == 0) {
                    result = "No column(s) selected? " + this.m_Column.getRange();
                    this.m_OutputToken = new Token((Object)row);
                } else {
                    for (int c : cols) {
                        Cell cell = row.getCell(c);
                        if (cell == null) {
                            cell = row.addCell(c);
                        }
                        if (this.m_ForceString) {
                            cell.setContentAsString(this.m_Value);
                            continue;
                        }
                        cell.setContent(this.m_Value);
                    }
                    this.m_OutputToken = new Token((Object)row);
                }
            }
        }
        return result;
    }
}

