/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseBoolean;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.RowComparator;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;

public class SpreadSheetSort
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = 8621434041912535939L;
    protected SpreadSheetColumnIndex[] m_SortColumn;
    protected BaseBoolean[] m_SortOrder;
    protected boolean m_Unique;

    public String globalInfo() {
        return "Sorts the rows of the spreadsheet according to the selected column indices and sort order (ascending/descending).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sort-column", "sortColumn", (Object)new SpreadSheetColumnIndex[]{new SpreadSheetColumnIndex("first")});
        this.m_OptionManager.add("sort-order", "sortOrder", (Object)new BaseBoolean[]{new BaseBoolean(Boolean.valueOf(true))});
        this.m_OptionManager.add("unique", "unique", (Object)false);
    }

    protected void initialize() {
        super.initialize();
        this.m_SortColumn = new SpreadSheetColumnIndex[0];
        this.m_SortOrder = new BaseBoolean[0];
    }

    public String getQuickInfo() {
        Object result;
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"sortColumn") && QuickInfoHelper.hasVariable((OptionHandler)this, (String)"sortOrder")) {
            result = QuickInfoHelper.getVariable((OptionHandler)this, (String)"sortColumn") + " and " + QuickInfoHelper.getVariable((OptionHandler)this, (String)"sortOrder");
        } else {
            result = "";
            for (int i = 0; i < this.m_SortColumn.length; ++i) {
                if (i > 0) {
                    result = (String)result + " and ";
                }
                result = (String)result + this.m_SortColumn[i].getIndex();
                if (this.m_SortOrder[i].booleanValue()) continue;
                result = (String)result + " (desc)";
            }
        }
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"unique", (boolean)this.m_Unique, (String)"unique", (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        return result;
    }

    public void setSortColumn(SpreadSheetColumnIndex[] value) {
        this.m_SortColumn = value;
        if (this.m_SortColumn.length != this.m_SortOrder.length) {
            this.m_SortOrder = (BaseBoolean[])Utils.adjustArray((Object)this.m_SortOrder, (int)this.m_SortColumn.length, (Object)new BaseBoolean(Boolean.valueOf(true)));
        }
        this.reset();
    }

    public SpreadSheetColumnIndex[] getSortColumn() {
        return this.m_SortColumn;
    }

    public String sortColumnTipText() {
        return "The columns to use for sorting.";
    }

    public void setSortOrder(BaseBoolean[] value) {
        this.m_SortOrder = value;
        if (this.m_SortColumn.length != this.m_SortOrder.length) {
            this.m_SortColumn = (SpreadSheetColumnIndex[])Utils.adjustArray((Object)this.m_SortColumn, (int)this.m_SortOrder.length, (Object)((Object)new SpreadSheetColumnIndex("first")));
        }
        this.reset();
    }

    public BaseBoolean[] getSortOrder() {
        return this.m_SortOrder;
    }

    public String sortOrderTipText() {
        return "The order of sorting for the columns (true = ascending, false = descending).";
    }

    public void setUnique(boolean value) {
        this.m_Unique = value;
        this.reset();
    }

    public boolean getUnique() {
        return this.m_Unique;
    }

    public String uniqueTipText() {
        return "If enabled, all duplicate rows (according to the sort setup) get dropped.";
    }

    protected String doExecute() {
        int i;
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        if (!this.m_NoCopy) {
            sheet = sheet.getClone();
        }
        int[] indices = new int[this.m_SortColumn.length];
        for (i = 0; i < this.m_SortColumn.length; ++i) {
            this.m_SortColumn[i].setSpreadSheet(sheet);
            indices[i] = this.m_SortColumn[i].getIntIndex();
        }
        boolean[] order = new boolean[this.m_SortOrder.length];
        for (i = 0; i < this.m_SortOrder.length; ++i) {
            order[i] = this.m_SortOrder[i].booleanValue();
        }
        RowComparator comp = new RowComparator(indices, order);
        sheet.sort(comp, this.m_Unique);
        this.m_OutputToken = new Token((Object)sheet);
        return result;
    }
}

