/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DefaultCompare;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetUnorderedColumnRange;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import adams.flow.transformer.SpreadSheetReorderColumns;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class SpreadSheetSortColumns
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 6177865465885016861L;
    protected SpreadSheetColumnRange m_Columns;
    protected Comparator m_Comparator;
    protected boolean m_Reverse;

    public String globalInfo() {
        return "Reorders a user-defined subset of columns by name using the specified comparator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
        this.m_OptionManager.add("comparator", "comparator", (Object)new DefaultCompare());
        this.m_OptionManager.add("reverse", "reverse", (Object)false);
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The subset of columns to perform the sorting on.";
    }

    public void setComparator(Comparator value) {
        this.m_Comparator = value;
        this.reset();
    }

    public Comparator getComparator() {
        return this.m_Comparator;
    }

    public String comparatorTipText() {
        return "The comparator to use; must implement " + Comparator.class.getName() + " and " + Serializable.class.getName();
    }

    public void setReverse(boolean value) {
        this.m_Reverse = value;
        this.reset();
    }

    public boolean getReverse() {
        return this.m_Reverse;
    }

    public String reverseTipText() {
        return "If enabled, the sorting order gets reversed.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"columns", (Object)((Object)this.m_Columns), (String)"cols: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"comparator", this.m_Comparator.getClass(), (String)", comp: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"reverse", (boolean)this.m_Reverse, (String)"reversed", (String)", ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        ArrayList<SortContainer> conts = new ArrayList<SortContainer>();
        TIntHashSet subset = new TIntHashSet();
        this.m_Columns.setData(sheet);
        for (int index : this.m_Columns.getIntIndices()) {
            conts.add(new SortContainer(sheet.getColumnName(index), index));
            subset.add(index);
        }
        if (conts.size() == 0) {
            result = "No columns selected?";
        }
        if (result == null) {
            int i;
            conts.sort(new ContainerComparator(this.m_Comparator));
            if (this.m_Reverse) {
                Collections.reverse(conts);
            }
            TIntArrayList newOrder = new TIntArrayList();
            boolean first = true;
            for (i = 0; i < sheet.getColumnCount(); ++i) {
                if (first) {
                    if (subset.contains(i)) {
                        first = false;
                        Object object = conts.iterator();
                        while (object.hasNext()) {
                            SortContainer cont = (SortContainer)object.next();
                            newOrder.add(cont.getIndex());
                        }
                        continue;
                    }
                    newOrder.add(i);
                    continue;
                }
                if (subset.contains(i)) continue;
                newOrder.add(i);
            }
            StringBuilder order = new StringBuilder();
            for (i = 0; i < newOrder.size(); ++i) {
                if (i > 0) {
                    order.append(",");
                }
                order.append("" + (newOrder.get(i) + 1));
            }
            SpreadSheetReorderColumns reorder = new SpreadSheetReorderColumns();
            reorder.setOrder(new SpreadSheetUnorderedColumnRange(order.toString()));
            reorder.input(new Token((Object)sheet));
            result = reorder.execute();
            if (result == null) {
                this.m_OutputToken = reorder.output();
            }
            reorder.cleanUp();
        }
        return result;
    }

    public static class ContainerComparator
    implements Comparator<SortContainer> {
        protected Comparator m_Comparator;

        public ContainerComparator(Comparator comp) {
            this.m_Comparator = comp;
        }

        @Override
        public int compare(SortContainer o1, SortContainer o2) {
            return this.m_Comparator.compare(o1.getName(), o2.getName());
        }
    }

    public static class SortContainer {
        protected String m_Name;
        protected int m_Index;

        public SortContainer(String name, int index) {
            this.m_Name = name;
            this.m_Index = index;
        }

        public String getName() {
            return this.m_Name;
        }

        public int getIndex() {
            return this.m_Index;
        }
    }
}

