/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetView;
import adams.data.spreadsheet.SpreadSheetViewCreator;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import gnu.trove.TIntCollection;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;

public class SpreadSheetSubsetFromGroup
extends AbstractSpreadSheetTransformer
implements SpreadSheetViewCreator {
    private static final long serialVersionUID = 5167598748037763968L;
    protected SpreadSheetColumnIndex m_Column;
    protected Range m_Rows;
    protected boolean m_CreateView;

    public String globalInfo() {
        return "Splits the spreadsheet into subsets using the supplied column and then returns the specified range of rows from each generated subset.\nThe spreadsheet is expected to be sorted on the grouping column.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("col", "column", (Object)new SpreadSheetColumnIndex("first"));
        this.m_OptionManager.add("row", "rows", (Object)new Range("first-last"));
        this.m_OptionManager.add("create-view", "createView", (Object)false);
    }

    public void setColumn(SpreadSheetColumnIndex value) {
        this.m_Column = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column which unique string values identify the subsets; " + this.m_Column.getExample();
    }

    public void setRows(Range value) {
        this.m_Rows = value;
        this.reset();
    }

    public Range getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The rows of the subset to retrieve.";
    }

    @Override
    public void setCreateView(boolean value) {
        this.m_CreateView = value;
        this.reset();
    }

    @Override
    public boolean getCreateView() {
        return this.m_CreateView;
    }

    @Override
    public String createViewTipText() {
        return "If enabled, then only a view of the subset is created.";
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)((Object)this.m_Column), (String)"col: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"rows", (Object)this.m_Rows, (String)", rows: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"createView", (boolean)this.m_CreateView, (String)", view only");
        if (value != null) {
            result = (String)result + value;
        }
        return result;
    }

    protected void transfer(TIntList group, TIntList indices) {
        TIntArrayList subset = new TIntArrayList();
        this.m_Rows.setMax(group.size());
        int[] rows = this.m_Rows.getIntIndices();
        for (int i = 0; i < rows.length; ++i) {
            subset.add(group.get(rows[i]));
        }
        indices.addAll((TIntCollection)subset);
        group.clear();
    }

    protected String doExecute() {
        int i;
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload(SpreadSheet.class);
        TIntArrayList indices = null;
        TIntArrayList group = new TIntArrayList();
        boolean alwaysEmpty = true;
        this.m_Column.setSpreadSheet(sheet);
        int col = this.m_Column.getIntIndex();
        if (col == -1) {
            result = "Failed to locate column: " + this.m_Column.getIndex();
        }
        if (result == null) {
            indices = new TIntArrayList();
            String key = null;
            for (i = 0; i < sheet.getRowCount(); ++i) {
                String oldKey = key;
                if (this.isStopped()) {
                    group.clear();
                    indices = null;
                    break;
                }
                key = sheet.getRow(i).getContent(col);
                if (oldKey == null) {
                    group.add(i);
                    continue;
                }
                if (key == null) continue;
                if (!key.equals(oldKey)) {
                    if (group.size() > 0) {
                        alwaysEmpty = false;
                    }
                    this.transfer((TIntList)group, (TIntList)indices);
                }
                group.add(i);
            }
            if (group.size() > 0 && indices != null) {
                if (group.size() > 0) {
                    alwaysEmpty = false;
                }
                this.transfer((TIntList)group, (TIntList)indices);
            }
        }
        if (indices != null) {
            SpreadSheet subset;
            if (this.m_CreateView) {
                subset = new SpreadSheetView(sheet, indices.toArray(), null);
            } else {
                subset = sheet.getHeader();
                for (i = 0; i < indices.size(); ++i) {
                    subset.addRow().assign((Row)sheet.getRow(indices.get(i)));
                }
            }
            this.m_OutputToken = new Token((Object)subset);
            if (alwaysEmpty) {
                this.getLogger().warning("Never matched any rows!");
            }
        }
        return result;
    }
}

