/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateTime;
import adams.core.DateTimeMsec;
import adams.core.QuickInfoHelper;
import adams.core.Time;
import adams.core.TimeMsec;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.cellfinder.CellFinder;
import adams.data.spreadsheet.cellfinder.CellLocation;
import adams.data.spreadsheet.cellfinder.CellRange;
import adams.event.VariableChangeListener;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.Compatibility;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class SpreadSheetTransformCells
extends AbstractInPlaceSpreadSheetTransformer
implements CallableActorUser {
    private static final long serialVersionUID = -2533024333073383813L;
    public static final String BACKUP_CALLABLEACTOR = "callable actor";
    protected CellFinder m_Finder;
    protected boolean m_ForceInputType;
    protected Cell.ContentType m_InputType;
    protected boolean m_SkipMissing;
    protected String m_MissingReplacementValue;
    protected Cell.ContentType m_MissingReplacementType;
    protected CallableActorReference m_Transformer;
    protected CallableActorHelper m_Helper;
    protected Actor m_CallableActor;
    protected Cell m_Cell;
    protected Compatibility m_Compatibility;

    public String globalInfo() {
        return "Finds cells in a spreadsheet and transforms them with a callable transformer.\nIn case of transformers having " + Object.class.getSimpleName() + " or " + Unknown.class.getSimpleName() + " in their types of classes that they accept, no proper type can be inferred automatically. Therefore it is recommended to manually enforce the 'input type'.\nIf the transformer generates a " + SpreadSheet.class.getName() + " object itself, this will get merged with the enclosing one: any additional columns get added and the content of the first row gets added to the row the trasnformed cell belongs to.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new CellRange());
        this.m_OptionManager.add("force-input-type", "forceInputType", (Object)false);
        this.m_OptionManager.add("input-type", "inputType", (Object)Cell.ContentType.STRING);
        this.m_OptionManager.add("skip-missing", "skipMissing", (Object)true);
        this.m_OptionManager.add("missing-replacement-value", "missingReplacementValue", (Object)"");
        this.m_OptionManager.add("missing-replacement-type", "missingReplacementType", (Object)Cell.ContentType.STRING);
        this.m_OptionManager.add("transformer", "transformer", (Object)new CallableActorReference("unknown"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    protected void reset() {
        super.reset();
        this.m_CallableActor = null;
        this.m_Cell = null;
        this.m_Compatibility = null;
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)"finder: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"transformer", (Object)this.m_Transformer, (String)", transformer: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"skipMissing", (boolean)this.m_SkipMissing, (String)"skip missing", (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"forceInputType", (boolean)this.m_ForceInputType, (String)"force input type", (String)", ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"noCopy", (boolean)this.m_NoCopy, (String)"no copy", (String)", ");
        return result;
    }

    public void setFinder(CellFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public CellFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The cell finder to use.";
    }

    public void setForceInputType(boolean value) {
        this.m_ForceInputType = value;
        this.reset();
    }

    public boolean getForceInputType() {
        return this.m_ForceInputType;
    }

    public String forceInputTypeTipText() {
        return "If enabled, the input type is forced to a user-specified type, rather than trying to determine type based on data types that the callable transformer accepts.";
    }

    public void setInputType(Cell.ContentType value) {
        this.m_InputType = value;
        this.reset();
    }

    public Cell.ContentType getInputType() {
        return this.m_InputType;
    }

    public String inputTypeTipText() {
        return "The input type to use in case the input type is enforced.";
    }

    public void setSkipMissing(boolean value) {
        this.m_SkipMissing = value;
        this.reset();
    }

    public boolean getSkipMissing() {
        return this.m_SkipMissing;
    }

    public String skipMissingTipText() {
        return "If enabled, missing cells are skipped.";
    }

    public void setMissingReplacementValue(String value) {
        this.m_MissingReplacementValue = value;
        this.reset();
    }

    public String getMissingReplacementValue() {
        return this.m_MissingReplacementValue;
    }

    public String missingReplacementValueTipText() {
        return "The string representation of the value to use for replacing missing values.";
    }

    public void setMissingReplacementType(Cell.ContentType value) {
        this.m_MissingReplacementType = value;
        this.reset();
    }

    public Cell.ContentType getMissingReplacementType() {
        return this.m_MissingReplacementType;
    }

    public String missingReplacementTypeTipText() {
        return "The data type to use for the replacement value for missing values.";
    }

    public void setTransformer(CallableActorReference value) {
        this.m_Transformer = value;
        this.reset();
    }

    public CallableActorReference getTransformer() {
        return this.m_Transformer;
    }

    public String transformerTipText() {
        return "The callable transformer to apply to the located cells.";
    }

    protected Actor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive((Actor)this, this.getTransformer());
    }

    public boolean hasCallableActor() {
        return this.m_CallableActor != null;
    }

    public Actor getCallableActor() {
        return this.m_CallableActor;
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_CALLABLEACTOR);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_CallableActor != null) {
            result.put(BACKUP_CALLABLEACTOR, this.m_CallableActor);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        super.restoreState(state);
        if (state.containsKey(BACKUP_CALLABLEACTOR)) {
            this.m_CallableActor = (Actor)state.get(BACKUP_CALLABLEACTOR);
            state.remove(BACKUP_CALLABLEACTOR);
        }
    }

    protected String setUpCallableActor() {
        String result = null;
        this.m_CallableActor = this.findCallableActor();
        if (this.m_CallableActor == null) {
            result = "Couldn't find callable transformer '" + this.getTransformer() + "'!";
        } else if (ActorUtils.isTransformer((Actor)this.m_CallableActor)) {
            HashSet variables = this.findVariables(this.m_CallableActor);
            this.m_DetectedVariables.addAll(variables);
            if (this.m_DetectedVariables.size() > 0) {
                this.getVariables().addVariableChangeListener((VariableChangeListener)this);
            }
        } else {
            result = "Callable actor '" + this.getTransformer() + "' is not a transformer!";
        }
        return result;
    }

    public String setUp() {
        String variable;
        String result = super.setUp();
        if (result == null && (variable = this.getOptionManager().getVariableForProperty("transformer")) == null) {
            result = this.setUpCallableActor();
        }
        return result;
    }

    protected void transfer(SpreadSheet source, Cell cell) {
        if (source.getRowCount() < 1) {
            if (this.isLoggingEnabled()) {
                this.getLogger().warning("No data rows generated for cell: " + cell.getContent());
            }
            return;
        }
        SpreadSheet target = cell.getSpreadSheet();
        Row targetRow = cell.getOwner();
        HeaderRow targetHeader = target.getHeaderRow();
        DataRow sourceRow = source.getRow(0);
        HeaderRow sourceHeader = source.getHeaderRow();
        for (int i = 0; i < sourceHeader.getCellCount(); ++i) {
            Cell hc = sourceHeader.getCell(i);
            if (targetHeader.indexOfContent(hc.getContent()) == -1) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Adding column: " + hc.getContent());
                }
                target.insertColumn(target.getColumnCount(), hc.getContent());
            }
            if (sourceRow.getCell(i) != null && !sourceRow.getCell(i).isMissing()) {
                int col = targetHeader.indexOfContent(hc.getContent());
                targetRow.addCell(col).assign(sourceRow.getCell(i));
            }
            if (this.isStopped()) break;
        }
    }

    protected String transformCell(CellLocation location, SpreadSheet sheet) {
        Class[] classIn;
        Cell cell;
        Object result = null;
        Object input = null;
        Object output = null;
        if (this.m_Cell == null) {
            this.m_Cell = sheet.newCell();
        }
        if (this.m_Compatibility == null) {
            this.m_Compatibility = new Compatibility();
        }
        if (!sheet.hasCell(location.getRow(), location.getColumn())) {
            if (this.m_SkipMissing) {
                return null;
            }
            input = this.m_Cell.parseContent(this.m_MissingReplacementValue, this.m_MissingReplacementType);
        }
        if ((cell = sheet.getCell(location.getRow(), location.getColumn())).isMissing()) {
            if (this.m_SkipMissing) {
                return null;
            }
            input = cell.parseContent(this.m_MissingReplacementValue, this.m_MissingReplacementType);
        }
        if (this.m_ForceInputType) {
            switch (this.m_InputType) {
                case BOOLEAN: {
                    classIn = new Class[]{Boolean.class};
                    break;
                }
                case LONG: {
                    classIn = new Class[]{Long.class};
                    break;
                }
                case DOUBLE: {
                    classIn = new Class[]{Double.class};
                    break;
                }
                case TIME: {
                    classIn = new Class[]{Time.class};
                    break;
                }
                case TIMEMSEC: {
                    classIn = new Class[]{TimeMsec.class};
                    break;
                }
                case DATE: {
                    classIn = new Class[]{Date.class};
                    break;
                }
                case DATETIME: {
                    classIn = new Class[]{DateTime.class};
                    break;
                }
                case DATETIMEMSEC: {
                    classIn = new Class[]{DateTimeMsec.class};
                    break;
                }
                case OBJECT: {
                    classIn = new Class[]{Object.class};
                    break;
                }
                default: {
                    classIn = new Class[]{String.class};
                    break;
                }
            }
        } else {
            classIn = ((InputConsumer)this.m_CallableActor).accepts();
        }
        if (input == null) {
            if (this.m_Compatibility.isCompatible(new Class[]{Double.class}, classIn)) {
                input = cell.toDouble();
            } else if (this.m_Compatibility.isCompatible(new Class[]{Integer.class}, classIn)) {
                input = cell.toLong().intValue();
            } else if (this.m_Compatibility.isCompatible(new Class[]{Long.class}, classIn)) {
                input = cell.toLong();
            } else if (this.m_Compatibility.isCompatible(new Class[]{Date.class}, classIn)) {
                input = cell.toDate();
            } else if (this.m_Compatibility.isCompatible(new Class[]{DateTime.class}, classIn)) {
                input = cell.toDateTime();
            } else if (this.m_Compatibility.isCompatible(new Class[]{Time.class}, classIn)) {
                input = cell.toTime();
            } else if (this.m_Compatibility.isCompatible(new Class[]{TimeMsec.class}, classIn)) {
                input = cell.toTimeMsec();
            } else if (this.m_Compatibility.isCompatible(new Class[]{String.class}, classIn)) {
                input = cell.getContent();
            } else if (this.m_Compatibility.isCompatible(new Class[]{Object.class}, classIn)) {
                input = cell.getNative();
            } else if (this.m_Compatibility.isCompatible(new Class[]{Unknown.class}, classIn)) {
                input = cell.getNative();
            } else {
                result = "Don't know how to get cell value for transformation input type:\n" + Utils.classesToString((Class[])classIn) + "/" + (input != null ? input.getClass().getName() : "null") + "/" + cell.getContent();
            }
        }
        if (result == null) {
            ((InputConsumer)this.m_CallableActor).input(new Token(input));
            result = this.m_CallableActor.execute();
        }
        if (result == null) {
            Class[] classOut = ((OutputProducer)this.m_CallableActor).generates();
            output = ((OutputProducer)this.m_CallableActor).output();
            if (output != null) {
                output = output.getPayload();
            }
            if (output instanceof Double) {
                cell.setContent((Double)output);
            } else if (output instanceof Integer) {
                cell.setContent((Integer)output);
            } else if (output instanceof Long) {
                cell.setContent((Long)output);
            } else if (output instanceof DateTime) {
                cell.setContent((DateTime)output);
            } else if (output instanceof Time) {
                cell.setContent((Time)output);
            } else if (output instanceof TimeMsec) {
                cell.setContent((TimeMsec)output);
            } else if (output instanceof Date) {
                cell.setContent((Date)output);
            } else if (output instanceof String) {
                if (((String)output).startsWith("=")) {
                    cell.setContent((String)output);
                } else {
                    cell.setContentAsString((String)output);
                }
            } else if (output instanceof SpreadSheet) {
                this.transfer((SpreadSheet)output, cell);
            } else {
                result = "Don't know how to set cell value for transformation output type:\n" + Utils.classesToString((Class[])classOut) + "/" + (output != null ? output.getClass().getName() : "null") + "\nThe input that resulted in this output:\n" + Utils.classesToString((Class[])classIn) + "/" + (input != null ? input.getClass().getName() : "null") + "/" + cell.getContent();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        if (this.m_CallableActor == null) {
            result = this.setUpCallableActor();
        }
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        SpreadSheet sheetNew = this.m_NoCopy ? sheetOld : sheetOld.getClone();
        Iterator<CellLocation> cells = this.m_Finder.findCells(sheetNew);
        if (!(this.m_CallableActor.getSkip() || this.m_CallableActor.isStopped() || this.isStopped())) {
            Actor actor = this.m_CallableActor;
            synchronized (actor) {
                while (cells.hasNext()) {
                    if (this.isStopped()) {
                        return null;
                    }
                    result = this.transformCell(cells.next(), sheetNew);
                    if (result == null) continue;
                }
            }
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)sheetNew);
        }
        return result;
    }
}

