/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUpdater;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.CollectionInsert;
import adams.gui.visualization.jfreechart.dataset.AbstractDatasetGenerator;
import adams.gui.visualization.jfreechart.dataset.DefaultXY;
import org.jfree.data.general.Dataset;

public class StorageJFreeChartAddSeries
extends AbstractTransformer
implements StorageUpdater {
    private static final long serialVersionUID = -4381778255320714964L;
    protected StorageName m_StorageName;
    protected AbstractDatasetGenerator m_Dataset;

    public String globalInfo() {
        return "Generates a series from the incoming spreadsheet and adds it to the specified JFreeChart dataset in storage.\nAfter inserting the object successfully, just forwards the object.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{CollectionInsert.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storageName", "storageName", (Object)new StorageName());
        this.m_OptionManager.add("dataset", "dataset", (Object)new DefaultXY());
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the storage item that represents the collection to update.";
    }

    public void setDataset(AbstractDatasetGenerator value) {
        this.m_Dataset = value;
        this.reset();
    }

    public AbstractDatasetGenerator getDataset() {
        return this.m_Dataset;
    }

    public String datasetTipText() {
        return "The dataset generator to use.";
    }

    public boolean isUpdatingStorage() {
        return !this.getSkip();
    }

    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"dataset", (Object)((Object)this.m_Dataset), (String)", dataset: ");
        return result;
    }

    protected String doExecute() {
        Object result = this.getOptionManager().ensureVariableForPropertyExists("storageName");
        if (result == null) {
            SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload(SpreadSheet.class);
            Dataset dataset = null;
            if (!this.getStorageHandler().getStorage().has(this.m_StorageName)) {
                result = "Dataset not available from storage: " + this.m_StorageName;
            } else {
                dataset = (Dataset)this.getStorageHandler().getStorage().get(this.m_StorageName);
            }
            if (result == null) {
                if (!dataset.getClass().equals(this.m_Dataset.generates())) {
                    result = "Dataset in storage (" + this.m_StorageName + ") is of type " + Utils.classToString((Object)dataset) + ", but dataset generator produces " + Utils.classToString(this.m_Dataset.generates()) + "!";
                } else {
                    dataset = this.m_Dataset.addSeries(dataset, sheet);
                    this.getStorageHandler().getStorage().put(this.m_StorageName, (Object)dataset);
                    this.m_OutputToken = new Token((Object)sheet);
                }
            }
        }
        return result;
    }
}

