/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.multispreadsheetoperation;

import adams.core.MessageCollection;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.SpreadSheet;

public abstract class AbstractMultiSpreadSheetOperation<O>
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = 1185449853784824033L;

    public String getQuickInfo() {
        return null;
    }

    public abstract int minNumSheetsRequired();

    public abstract int maxNumSheetsRequired();

    public abstract Class generates();

    protected void check(SpreadSheet[] sheets) {
        if (sheets == null || sheets.length == 0) {
            throw new IllegalStateException("No sheets provided!");
        }
        if (this.minNumSheetsRequired() > 0 && sheets.length < this.minNumSheetsRequired()) {
            throw new IllegalStateException("Not enough sheets supplied (min > supplied): " + this.minNumSheetsRequired() + " > " + sheets.length);
        }
        if (this.maxNumSheetsRequired() > 0 && sheets.length > this.maxNumSheetsRequired()) {
            throw new IllegalStateException("Too many sheets supplied (max < supplied): " + this.maxNumSheetsRequired() + " < " + sheets.length);
        }
    }

    protected abstract O doProcess(SpreadSheet[] var1, MessageCollection var2);

    public O process(SpreadSheet[] sheets, MessageCollection errors) {
        this.check(sheets);
        return this.doProcess(sheets, errors);
    }
}

