/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.multispreadsheetoperation;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.transformer.multispreadsheetoperation.AbstractIndentifiableRowOperation;
import java.util.HashSet;

public class Difference
extends AbstractIndentifiableRowOperation {
    private static final long serialVersionUID = -5056170789277731638L;

    public String globalInfo() {
        return "Computes the difference of the numeric cells between two spreadsheets.\nThe values of the second spreadsheet are subtracted from the first one.\nIf no 'key' columns are defined, the current order of rows is used for comparison.";
    }

    @Override
    protected Row performOperation(SpreadSheet output, Row row1, Row row2) {
        Row result = row1.getClone(output);
        result.clear();
        HashSet<Integer> indices = new HashSet<Integer>();
        for (int i : this.m_ColIndices) {
            indices.add(this.m_ColIndices[i]);
        }
        Object object = row1.cellKeys().iterator();
        while (object.hasNext()) {
            String key = (String)object.next();
            int index = row1.getOwner().getHeaderRow().indexOf(key);
            Cell cell1 = row1.getCell(key);
            Cell cell2 = row2.getCell(key);
            if (indices.contains(index)) {
                result.addCell(key).setContent(cell1.getContent());
                continue;
            }
            if (cell1 == null || cell2 == null) {
                result.addCell(key).setContent("?");
                continue;
            }
            if (cell1.isMissing() || cell2.isMissing()) {
                result.addCell(key).setContent("?");
                continue;
            }
            if (cell1.isNumeric() && cell2.isNumeric()) {
                result.addCell(key).setContent(Double.valueOf(cell1.toDouble() - cell2.toDouble()));
                continue;
            }
            if (cell1.getContent().equals(cell2.getContent())) {
                result.addCell(key).setContent(cell1.getContent());
                continue;
            }
            result.addCell(key).setContent("?");
        }
        return result;
    }
}

