/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.plotgenerator;

import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.Utils;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.container.SequencePlotterContainer;
import java.util.List;

public abstract class AbstractPlotGenerator
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = -7535085726098063330L;
    public static final String MISSING_CELL_VALUE = "MISSING";
    protected double m_DefaultCellValue;
    protected SpreadSheetColumnRange m_PlotNameRange;
    protected String m_PlotNameSeparator;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("default-cell-value", "defaultCellValue", (Object)-1.0);
        this.m_OptionManager.add("plot-name-range", "plotNameRange", (Object)"");
        this.m_OptionManager.add("plot-name-separator", "plotNameSeparator", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_PlotNameRange = new SpreadSheetColumnRange();
    }

    public void setDefaultCellValue(double value) {
        this.m_DefaultCellValue = value;
        this.reset();
    }

    public double getDefaultCellValue() {
        return this.m_DefaultCellValue;
    }

    public String defaultCellValueTipText() {
        return "The default value for missing or non-numeric cells.";
    }

    public void setPlotNameRange(String value) {
        this.m_PlotNameRange.setRange(value);
        this.reset();
    }

    public String getPlotNameRange() {
        return this.m_PlotNameRange.getRange();
    }

    public String plotNameRangeTipText() {
        return "The range of columns to use for generating the plot name (overrides any plot generator specific names); " + this.m_PlotNameRange.getExample();
    }

    public void setPlotNameSeparator(String value) {
        this.m_PlotNameSeparator = value;
        this.reset();
    }

    public String getPlotNameSeparator() {
        return this.m_PlotNameSeparator;
    }

    public String plotNameSeparatorTipText() {
        return "The separator to use when constructing the plot name from cell values.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"plotNameRange", (Object)(this.getPlotNameRange().isEmpty() ? "-default-" : this.getPlotNameRange()), (String)"plot: ");
    }

    protected void check(SpreadSheet sheet) {
        if (sheet == null) {
            throw new IllegalStateException("No spreadsheet provided!");
        }
        this.m_PlotNameRange.setData(sheet);
    }

    protected String getCellString(Row row, int index) {
        String result = MISSING_CELL_VALUE;
        Cell cell = row.getCell(index);
        if (cell != null && !cell.isMissing()) {
            result = cell.getContent();
        }
        return result;
    }

    protected Comparable getCellValue(Row row, int index, Comparable defaultValue) {
        Object result = defaultValue;
        Cell cell = row.getCell(index);
        if (cell != null && !cell.isMissing()) {
            result = cell.isNumeric() ? new Double(Utils.toDouble((String)cell.getContent())) : (cell.isTime() ? new Double(cell.toTime().getTime()) : (cell.isDate() ? new Double(cell.toDate().getTime()) : (cell.isDateTime() ? new Double(cell.toDateTime().getTime()) : cell.getContent())));
        }
        return result;
    }

    protected Object getCellObject(Row row, int index, Object defaultValue) {
        Object result = defaultValue;
        Cell cell = row.getCell(index);
        if (cell != null && !cell.isMissing()) {
            result = cell.getNative();
        }
        return result;
    }

    protected Comparable getCellValue(Row row, int index) {
        return this.getCellValue(row, index, Double.valueOf(this.m_DefaultCellValue));
    }

    protected String getActualPlotName(Row row, String defValue) {
        Object result = defValue;
        if (!this.getPlotNameRange().isEmpty()) {
            int[] indices = this.m_PlotNameRange.getIntIndices();
            result = "";
            for (int i = 0; i < indices.length; ++i) {
                if (i > 0) {
                    result = (String)result + this.m_PlotNameSeparator;
                }
                result = (String)result + this.getCellString(row, indices[i]);
            }
        }
        return result;
    }

    protected abstract List<SequencePlotterContainer> doGenerate(SpreadSheet var1);

    public List<SequencePlotterContainer> generate(SpreadSheet sheet) {
        this.check(sheet);
        return this.doGenerate(sheet);
    }
}

