/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.plotgenerator;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import java.util.ArrayList;
import java.util.List;

public class RowWisePlotGenerator
extends AbstractPlotGenerator {
    private static final long serialVersionUID = -1679247321811941656L;
    protected SpreadSheetColumnIndex m_IDColumn;
    protected SpreadSheetColumnRange m_DataColumns;
    protected SpreadSheetColumnRange m_MetaDataColumns;
    protected boolean m_AddColumnName;

    public String globalInfo() {
        return "Generates a separate plot per row in the spreadsheet, using the specified columns as data points. Additional meta-data columns can be specified as well. The optional ID column can be used to name the row plots.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("id-column", "IDColumn", (Object)"");
        this.m_OptionManager.add("data-columns", "dataColumns", (Object)"");
        this.m_OptionManager.add("meta-data-columns", "metaDataColumns", (Object)"");
        this.m_OptionManager.add("add-column-name", "addColumnName", (Object)false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_IDColumn = new SpreadSheetColumnIndex();
        this.m_DataColumns = new SpreadSheetColumnRange();
        this.m_MetaDataColumns = new SpreadSheetColumnRange();
    }

    @Override
    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"IDColumn", (Object)(this.getIDColumn().isEmpty() ? "-none-" : this.getIDColumn()), (String)", ID: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"dataColumns", (Object)(this.getDataColumns().isEmpty() ? "-none-" : this.getDataColumns()), (String)", data: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"metaDataColumns", (Object)(this.getMetaDataColumns().isEmpty() ? "-none-" : this.getMetaDataColumns()), (String)", meta-data: ");
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"addColumnName", (boolean)this.m_AddColumnName, (String)"col name", (String)", ");
        if (value != null) {
            result = (String)result + value;
        }
        return result;
    }

    public void setIDColumn(String value) {
        this.m_IDColumn.setIndex(value);
        this.reset();
    }

    public String getIDColumn() {
        return this.m_IDColumn.getIndex();
    }

    public String IDColumnTipText() {
        return "The (optional) column to use for naming the row plot; " + this.m_IDColumn.getExample();
    }

    public void setDataColumns(String value) {
        this.m_DataColumns.setRange(value);
        this.reset();
    }

    public String getDataColumns() {
        return this.m_DataColumns.getRange();
    }

    public String dataColumnsTipText() {
        return "The range of columns to include in the plot; " + this.m_DataColumns.getExample();
    }

    public void setMetaDataColumns(String value) {
        this.m_MetaDataColumns.setRange(value);
        this.reset();
    }

    public String getMetaDataColumns() {
        return this.m_MetaDataColumns.getRange();
    }

    public String metaDataColumnsTipText() {
        return "The range of columns to add as meta-data in the plot; " + this.m_MetaDataColumns.getExample();
    }

    public void setAddColumnName(boolean value) {
        this.m_AddColumnName = value;
        this.reset();
    }

    public boolean getAddColumnName() {
        return this.m_AddColumnName;
    }

    public String addColumnNameTipText() {
        return "If enabled, the column name gets added to the meta-data.";
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_IDColumn.setSpreadSheet(sheet);
        this.m_DataColumns.setSpreadSheet(sheet);
        if (this.m_DataColumns.getIntIndices().length == 0) {
            throw new IllegalStateException("No data columns defined/available?");
        }
        this.m_MetaDataColumns.setSpreadSheet(sheet);
    }

    @Override
    protected List<SequencePlotterContainer> doGenerate(SpreadSheet sheet) {
        ArrayList<SequencePlotterContainer> result = new ArrayList<SequencePlotterContainer>();
        int idCol = this.m_IDColumn.getIntIndex();
        int[] dataCols = this.m_DataColumns.getIntIndices();
        int[] metaCols = this.m_MetaDataColumns.getIntIndices();
        for (int i = 0; i < sheet.getRowCount(); ++i) {
            DataRow row = sheet.getRow(i);
            Object name = idCol == -1 ? "" + (i + 1) : this.getCellString((Row)row, idCol);
            for (int n = 0; n < dataCols.length; ++n) {
                Comparable comp = this.getCellValue((Row)row, dataCols[n], null);
                if (comp == null) continue;
                SequencePlotterContainer cont = new SequencePlotterContainer(this.getActualPlotName((Row)row, (String)name), (Comparable)new Double(n), comp);
                for (int m = 0; m < metaCols.length; ++m) {
                    cont.addMetaData(sheet.getColumnName(metaCols[m]), this.getCellObject((Row)row, metaCols[m], null));
                }
                if (this.m_AddColumnName) {
                    cont.addMetaData("column", (Object)sheet.getColumnName(dataCols[n]));
                }
                result.add(cont);
            }
        }
        return result;
    }
}

