/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.plotgenerator;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.transformer.plotgenerator.AbstractPlotGenerator;
import java.util.ArrayList;
import java.util.List;

public class SimplePlotGenerator
extends AbstractPlotGenerator {
    private static final long serialVersionUID = -1679247321811941656L;
    protected SpreadSheetColumnRange m_PlotColumns;
    protected SpreadSheetColumnRange m_MetaDataColumns;

    public String globalInfo() {
        return "Plots the numeric data from one or more columns. The plot name is the column name and the X value is the row index.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "plotColumns", (Object)"");
        this.m_OptionManager.add("meta-data-columns", "metaDataColumns", (Object)"");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PlotColumns = new SpreadSheetColumnRange();
        this.m_MetaDataColumns = new SpreadSheetColumnRange();
    }

    @Override
    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"plotColumns", (Object)(this.getPlotColumns().isEmpty() ? "-none-" : this.getPlotColumns()), (String)", cols: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"metaDataColumns", (Object)(this.getMetaDataColumns().isEmpty() ? "-none-" : this.getMetaDataColumns()), (String)", meta-data: ");
        return result;
    }

    public void setPlotColumns(String value) {
        this.m_PlotColumns.setRange(value);
        this.reset();
    }

    public String getPlotColumns() {
        return this.m_PlotColumns.getRange();
    }

    public String plotColumnsTipText() {
        return "The range of columns to include in the plot; " + this.m_PlotColumns.getExample();
    }

    public void setMetaDataColumns(String value) {
        this.m_MetaDataColumns.setRange(value);
        this.reset();
    }

    public String getMetaDataColumns() {
        return this.m_MetaDataColumns.getRange();
    }

    public String metaDataColumnsTipText() {
        return "The range of columns to add as meta-data in the plot; " + this.m_MetaDataColumns.getExample();
    }

    @Override
    protected void check(SpreadSheet sheet) {
        super.check(sheet);
        this.m_PlotColumns.setSpreadSheet(sheet);
        if (this.m_PlotColumns.getIntIndices().length == 0) {
            throw new IllegalStateException("No plot columns defined/available?");
        }
        this.m_MetaDataColumns.setSpreadSheet(sheet);
    }

    @Override
    protected List<SequencePlotterContainer> doGenerate(SpreadSheet sheet) {
        int i;
        ArrayList<SequencePlotterContainer> result = new ArrayList<SequencePlotterContainer>();
        int[] plotCols = this.m_PlotColumns.getIntIndices();
        String[] plotNames = new String[plotCols.length];
        int[] metaCols = this.m_MetaDataColumns.getIntIndices();
        for (i = 0; i < plotNames.length; ++i) {
            plotNames[i] = sheet.getHeaderRow().getCell(plotCols[i]).getContent();
        }
        for (i = 0; i < sheet.getRowCount(); ++i) {
            DataRow row = sheet.getRow(i);
            for (int n = 0; n < plotCols.length; ++n) {
                SequencePlotterContainer cont = new SequencePlotterContainer(this.getActualPlotName((Row)row, plotNames[n]), (Comparable)new Double(i), this.getCellValue((Row)row, plotCols[n]));
                for (int m = 0; m < metaCols.length; ++m) {
                    cont.addMetaData(sheet.getColumnName(metaCols[m]), this.getCellObject((Row)row, metaCols[m], null));
                }
                result.add(cont);
            }
        }
        return result;
    }
}

