/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.data.conversion.AbstractSpreadSheetColumnConverter;
import adams.data.conversion.SpreadSheetAnyColumnToString;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.gui.core.GUIHelper;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.TableRowRange;
import adams.gui.core.spreadsheettable.AbstractProcessColumn;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItemHelper;
import adams.gui.goe.GenericObjectEditorDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.table.TableModel;

public class ChangeColumnType
extends AbstractProcessColumn {
    private static final long serialVersionUID = 3101728458818516005L;

    public String globalInfo() {
        return "Allows the user to change the type of a column.";
    }

    public String getMenuItem() {
        return "Change column type...";
    }

    public boolean handlesRowRange(TableRowRange range) {
        return range == TableRowRange.ALL;
    }

    public boolean doProcessColumn(SpreadSheetTablePopupMenuItemHelper.TableState state) {
        GenericObjectEditorDialog setup = GUIHelper.getParentDialog((Container)state.table) != null ? new GenericObjectEditorDialog(GUIHelper.getParentDialog((Container)state.table), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(GUIHelper.getParentFrame((Container)state.table), true);
        setup.setDefaultCloseOperation(2);
        setup.setUISettingsPrefix(AbstractSpreadSheetColumnConverter.class);
        setup.getGOEEditor().setClassType(AbstractSpreadSheetColumnConverter.class);
        setup.getGOEEditor().setCanChangeClassInDialog(true);
        AbstractSpreadSheetColumnConverter last = (AbstractSpreadSheetColumnConverter)((Object)state.table.getLastSetup(((Object)((Object)this)).getClass(), true, false));
        if (last == null) {
            last = new SpreadSheetAnyColumnToString();
        }
        last.setNoCopy(true);
        last.setColumn(new SpreadSheetColumnIndex("" + (state.actCol + 1)));
        setup.setCurrent((Object)last);
        setup.setLocationRelativeTo(GUIHelper.getParentComponent((Component)state.table));
        setup.setVisible(true);
        if (setup.getResult() != 0) {
            return false;
        }
        last = (AbstractSpreadSheetColumnConverter)((Object)setup.getCurrent());
        last.setNoCopy(true);
        last.setColumn(new SpreadSheetColumnIndex("" + (state.actCol + 1)));
        state.table.addLastSetup(((Object)((Object)this)).getClass(), true, false, (Object)last);
        last.setInput(state.table.toSpreadSheet());
        String msg = last.convert();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)GUIHelper.getParentComponent((Component)state.table), (String)("Failed to convert column: " + msg));
        } else {
            state.table.setModel((TableModel)new SpreadSheetTableModel((SpreadSheet)last.getOutput()));
        }
        last.cleanUp();
        return msg == null;
    }
}

