/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.AbstractProcessSelectedRows;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItemHelper;
import adams.gui.dialog.PropertiesParameterDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.io.File;

public class CopySelectedFiles
extends AbstractProcessSelectedRows {
    private static final long serialVersionUID = 7786133414905315983L;
    public static final String KEY_COLUMN = "column";
    public static final String KEY_TARGETDIR = "targetdir";

    public String globalInfo() {
        return "Allows the user to copy the selected files in the specified column.";
    }

    public String getIconName() {
        return "copy.gif";
    }

    public int minNumRows() {
        return 1;
    }

    public int maxNumRows() {
        return -1;
    }

    protected String getDefaultMenuItem() {
        return "Copy selected file(s)";
    }

    protected Properties promptParameters(SpreadSheetTable table) {
        PropertiesParameterDialog dialog = GUIHelper.getParentDialog((Container)table) != null ? new PropertiesParameterDialog(GUIHelper.getParentDialog((Container)table), Dialog.ModalityType.DOCUMENT_MODAL) : new PropertiesParameterDialog(GUIHelper.getParentFrame((Container)table), true);
        PropertiesParameterPanel panel = dialog.getPropertiesParameterPanel();
        panel.addPropertyType(KEY_COLUMN, PropertiesParameterPanel.PropertyType.INDEX);
        panel.setLabel(KEY_COLUMN, "Column");
        panel.setHelp(KEY_COLUMN, "The column with the file names");
        panel.addPropertyType(KEY_TARGETDIR, PropertiesParameterPanel.PropertyType.DIRECTORY_ABSOLUTE);
        panel.setLabel(KEY_TARGETDIR, "Target dir");
        panel.setHelp(KEY_TARGETDIR, "The directory to copy the files to");
        panel.setPropertyOrder(new String[]{KEY_COLUMN, KEY_TARGETDIR});
        Properties last = new Properties();
        last.setProperty(KEY_COLUMN, "first");
        last.setPath(KEY_TARGETDIR, new PlaceholderDirectory().getAbsolutePath());
        dialog.setProperties(last);
        last = (Properties)table.getLastSetup(((Object)((Object)this)).getClass(), false, true);
        if (last != null) {
            dialog.setProperties(last);
        }
        dialog.setTitle(this.getMenuItem());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)table.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return null;
        }
        return dialog.getProperties();
    }

    protected boolean doProcessSelectedRows(SpreadSheetTablePopupMenuItemHelper.TableState state) {
        Properties last = this.promptParameters(state.table);
        if (last == null) {
            return false;
        }
        SpreadSheet sheet = state.table.toSpreadSheet(state.range, true);
        SpreadSheetColumnIndex column = new SpreadSheetColumnIndex(last.getProperty(KEY_COLUMN, "first"));
        column.setData(sheet);
        int col = column.getIntIndex();
        if (col == -1) {
            GUIHelper.showErrorMessage((Component)state.table.getParent(), (String)("Failed to locate column:" + column));
            return false;
        }
        PlaceholderDirectory targetDir = new PlaceholderDirectory(last.getPath(KEY_TARGETDIR, new PlaceholderDirectory().getAbsolutePath()));
        state.table.addLastSetup(((Object)((Object)this)).getClass(), false, false, (Object)last);
        MessageCollection errors = new MessageCollection();
        for (int row : state.actRows) {
            PlaceholderFile sourceFile = new PlaceholderFile(sheet.getCell(row, col).toString());
            try {
                if (FileUtils.copy((File)sourceFile, (File)targetDir)) continue;
                errors.add("Failed to copy '" + (File)sourceFile + "' to '" + (File)targetDir + "'!");
            }
            catch (Exception e) {
                errors.add("Failed to copy '" + (File)sourceFile + "' to '" + (File)targetDir + "'!", (Throwable)e);
            }
        }
        if (!errors.isEmpty()) {
            GUIHelper.showErrorMessage((Component)state.table.getParent(), (String)("Failed to copy files:\n" + errors));
        }
        return errors.isEmpty();
    }
}

