/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.gui.core.GUIHelper;
import adams.gui.core.TableRowRange;
import adams.gui.core.spreadsheettable.AbstractProcessColumn;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItemHelper;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.event.SortSetupEvent;
import adams.gui.event.SortSetupListener;
import adams.gui.tools.spreadsheetviewer.SortPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;

public class DataSort
extends AbstractProcessColumn {
    private static final long serialVersionUID = 7761583015659462758L;
    protected SortPanel m_SortPanel;

    public String globalInfo() {
        return "Allows sorting the data using multiple columns.";
    }

    public String getIconName() {
        return "sort-ascending.png";
    }

    public String getMenuItem() {
        return "Sort...";
    }

    public boolean handlesRowRange(TableRowRange range) {
        return range == TableRowRange.ALL;
    }

    public boolean doProcessColumn(SpreadSheetTablePopupMenuItemHelper.TableState state) {
        final ApprovalDialog dialog = GUIHelper.getParentDialog((Container)state.table) != null ? new ApprovalDialog(GUIHelper.getParentDialog((Container)state.table), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(GUIHelper.getParentFrame((Container)state.table), true);
        dialog.setDefaultCloseOperation(2);
        dialog.setTitle("Sort");
        dialog.getApproveButton().setEnabled(false);
        if (this.m_SortPanel == null) {
            this.m_SortPanel = new SortPanel();
            this.m_SortPanel.addSortSetupListener(new SortSetupListener(){

                @Override
                public void sortSetupChanged(SortSetupEvent e) {
                    dialog.getApproveButton().setEnabled(e.getSortPanel().isValidSetup());
                }
            });
        }
        if (this.m_SortPanel.setSpreadSheet(state.table.toSpreadSheet())) {
            this.m_SortPanel.addDefinition();
        }
        dialog.getApproveButton().setEnabled(this.m_SortPanel.isValidSetup());
        dialog.getContentPane().add((Component)((Object)this.m_SortPanel), "Center");
        dialog.pack();
        dialog.setLocationRelativeTo((Component)dialog.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return false;
        }
        state.table.sort(this.m_SortPanel.getComparator());
        return true;
    }
}

