/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.ObjectCopyHelper;
import adams.core.Properties;
import adams.core.Range;
import adams.core.Shortening;
import adams.core.Utils;
import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.flow.control.Flow;
import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.sink.JFreeChartPlot;
import adams.flow.source.StorageValue;
import adams.gui.chooser.AbstractChooserPanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.TableRowRange;
import adams.gui.core.spreadsheettable.PlotColumn;
import adams.gui.core.spreadsheettable.PlotRow;
import adams.gui.core.spreadsheettable.PlotSelectedRows;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItem;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItemHelper;
import adams.gui.dialog.PropertiesParameterDialog;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.visualization.jfreechart.chart.XYLineChart;
import adams.gui.visualization.jfreechart.dataset.DefaultXY;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javax.swing.SwingWorker;

public class JFreeChart
extends AbstractOptionHandler
implements PlotColumn,
PlotRow,
PlotSelectedRows {
    private static final long serialVersionUID = -5624002368001818142L;
    public static final String KEY_COLUMNS = "columns";
    public static final String KEY_PLOT = "plot";
    public static final int MAX_POINTS = 1000;

    public String globalInfo() {
        return "Allows to generate a JFreeChart plot from a spreadsheet row or column";
    }

    public String getMenuItem() {
        return "JFreeChart...";
    }

    public String getIconName() {
        return "jfreechart.gif";
    }

    public int compareTo(SpreadSheetTablePopupMenuItem o) {
        return this.getMenuItem().compareTo(o.getMenuItem());
    }

    public boolean handlesRowRange(TableRowRange range) {
        return true;
    }

    protected Properties promptParameters(SpreadSheetTable table, boolean isColumn) {
        PropertiesParameterDialog dialog = GUIHelper.getParentDialog((Container)table) != null ? new PropertiesParameterDialog(GUIHelper.getParentDialog((Container)table), Dialog.ModalityType.DOCUMENT_MODAL) : new PropertiesParameterDialog(GUIHelper.getParentFrame((Container)table), true);
        PropertiesParameterPanel panel = dialog.getPropertiesParameterPanel();
        if (!isColumn) {
            panel.addPropertyType(KEY_COLUMNS, PropertiesParameterPanel.PropertyType.RANGE);
            panel.setLabel(KEY_COLUMNS, "Columns");
            panel.setHelp(KEY_COLUMNS, "The columns to use for the plot");
        }
        panel.addPropertyType(KEY_PLOT, PropertiesParameterPanel.PropertyType.OBJECT_EDITOR);
        panel.setLabel(KEY_PLOT, "Plot");
        panel.setHelp(KEY_PLOT, "How to display the data");
        panel.setChooser(KEY_PLOT, (AbstractChooserPanel)new GenericObjectEditorPanel(Actor.class, (Object)new JFreeChartPlot(), false));
        if (!isColumn) {
            panel.setPropertyOrder(new String[]{KEY_COLUMNS, KEY_PLOT});
        }
        Properties last = new Properties();
        if (!isColumn) {
            last.setProperty(KEY_COLUMNS, "first-last");
        }
        last.setObject(KEY_PLOT, (Object)new JFreeChartPlot());
        dialog.setProperties(last);
        last = (Properties)table.getLastSetup(((Object)((Object)this)).getClass(), true, !isColumn);
        if (last != null) {
            dialog.setProperties(last);
        }
        dialog.setTitle(this.getMenuItem());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)table.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return null;
        }
        return dialog.getProperties();
    }

    protected void createPlot(final SpreadSheetTable table, final boolean isColumn, final SpreadSheet data, final String title, final int[] spRows) {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                Flow flow = new Flow();
                flow.setDefaultCloseOperation(2);
                StorageValue sv = new StorageValue();
                sv.setStorageName(new StorageName("values"));
                flow.add((Actor)sv);
                Properties last = (Properties)table.getLastSetup(((Object)((Object)JFreeChart.this)).getClass(), true, !isColumn);
                JFreeChartPlot plot = (JFreeChartPlot)((Object)ObjectCopyHelper.copyObject((Object)((Object)((JFreeChartPlot)((Object)last.getObject(JFreeChart.KEY_PLOT, JFreeChartPlot.class, (Object)new JFreeChartPlot()))))));
                if (spRows != null) {
                    DefaultXY dataset = new DefaultXY();
                    dataset.setX(new SpreadSheetColumnIndex("1"));
                    dataset.setY(new SpreadSheetColumnRange(Utils.arrayToString((Object)spRows)));
                    plot.setDataset(dataset);
                    XYLineChart chart = new XYLineChart();
                    chart.setLegend(true);
                    chart.setTitle(title);
                    plot.setChart(chart);
                } else {
                    XYLineChart chart = new XYLineChart();
                    chart.setLegend(false);
                    chart.setTitle(title);
                    plot.setChart(chart);
                }
                plot.setShortTitle(true);
                plot.setName(title);
                plot.setX(-2);
                plot.setY(-2);
                flow.add((Actor)plot);
                flow.setUp();
                flow.getStorage().put(new StorageName("values"), (Object)data);
                flow.execute();
                flow.wrapUp();
                return null;
            }
        };
        worker.execute();
    }

    protected void plot(SpreadSheetTablePopupMenuItemHelper.TableState state, boolean isColumn, int index, int[] indices) {
        int[] spRows;
        String title;
        ArrayList[] list;
        int n;
        Cell cell;
        int i;
        int numPoints;
        SpreadSheet sheet = isColumn ? state.table.toSpreadSheet(state.range, true) : state.table.toSpreadSheet();
        int n2 = numPoints = isColumn ? sheet.getRowCount() : sheet.getColumnCount();
        if (numPoints > 1000) {
            String newPoints = GUIHelper.showInputDialog(null, (String)"More than 1000 data points to plot - enter sample size:", (String)("" + numPoints));
            if (newPoints == null) {
                return;
            }
            if (!Utils.isInteger((String)newPoints)) {
                return;
            }
            numPoints = Integer.parseInt(newPoints) != numPoints ? Integer.parseInt(newPoints) : -1;
        } else {
            numPoints = -1;
        }
        Properties last = this.promptParameters(state.table, isColumn);
        if (last == null) {
            return;
        }
        state.table.addLastSetup(((Object)((Object)this)).getClass(), true, !isColumn, (Object)last);
        ArrayList[] tmp = indices == null ? new ArrayList[]{new ArrayList()} : new ArrayList[indices.length];
        boolean sorted = false;
        boolean asc = state.table.isAscending();
        if (isColumn) {
            sorted = state.table.getSortColumn() == state.selCol;
            for (i = 0; i < sheet.getRowCount(); ++i) {
                cell = sheet.getCell(i, state.actCol);
                if (cell.isMissing() || !cell.isNumeric()) continue;
                tmp[0].add(cell.toDouble());
            }
        } else {
            int[] rows = indices == null ? new int[index] : indices;
            Range columns = new Range(last.getProperty(KEY_COLUMNS, "first-last"));
            columns.setMax(sheet.getColumnCount());
            int[] cols = columns.getIntIndices();
            for (n = 0; n < rows.length; ++n) {
                tmp[n] = new ArrayList();
                int row = rows[n];
                for (i = 0; i < cols.length; ++i) {
                    if (!sheet.getRow(row).hasCell(cols[i]) || (cell = sheet.getRow(row).getCell(cols[i])).isMissing() || !cell.isNumeric()) continue;
                    tmp[n].add(cell.toDouble());
                }
            }
        }
        if (numPoints > -1) {
            list = new ArrayList[tmp.length];
            for (i = 0; i < tmp.length; ++i) {
                numPoints = Math.min(numPoints, tmp[i].size());
                Collections.shuffle(tmp[i], new Random(1L));
                list[i] = tmp[i].subList(0, numPoints);
            }
        } else {
            list = tmp;
        }
        if (sorted) {
            for (i = 0; i < list.length; ++i) {
                Collections.sort(list[i]);
                if (asc) continue;
                Collections.reverse(list[i]);
            }
        }
        DefaultSpreadSheet data = new DefaultSpreadSheet();
        data.getHeaderRow().addCell("x").setContentAsString(isColumn ? "Row" : "Column");
        if (isColumn) {
            data.getHeaderRow().addCell("y0").setContentAsString(sheet.getColumnName(index));
        } else if (indices == null) {
            data.getHeaderRow().addCell("y0").setContentAsString("Row " + (index + 2));
        } else {
            for (i = 0; i < indices.length; ++i) {
                data.getHeaderRow().addCell("y" + i).setContentAsString("Row " + (indices[i] + 2));
            }
        }
        for (i = 0; i < list[0].size(); ++i) {
            DataRow srow = data.addRow();
            srow.addCell("x").setContent(Double.valueOf((double)i + 1.0));
            for (n = 0; n < list.length; ++n) {
                srow.addCell("y" + n).setContent((Double)list[n].get(i));
            }
        }
        if (isColumn) {
            title = "Column " + (index + 1) + "/" + sheet.getColumnName(index);
            spRows = null;
        } else if (indices == null) {
            title = "Row " + (index + 2);
            spRows = null;
        } else {
            int[] actRows = Utils.adjustIndices((int[])indices, (int)2);
            spRows = new int[indices.length];
            for (i = 0; i < indices.length; ++i) {
                spRows[i] = i + 2;
            }
            title = "Row" + (actRows.length != 1 ? "s" : "") + " " + Shortening.shortenMiddle((String)Utils.arrayToString((Object)actRows), (int)40);
        }
        this.createPlot(state.table, isColumn, (SpreadSheet)data, title, spRows);
    }

    public boolean plotColumn(SpreadSheetTablePopupMenuItemHelper.TableState state) {
        this.plot(state, true, state.actCol, null);
        return true;
    }

    public boolean plotRow(SpreadSheetTablePopupMenuItemHelper.TableState state) {
        this.plot(state, false, state.actRow, null);
        return true;
    }

    public int minNumRows() {
        return 1;
    }

    public int maxNumRows() {
        return -1;
    }

    public boolean plotSelectedRows(SpreadSheetTablePopupMenuItemHelper.TableState state) {
        this.plot(state, false, state.actRow, state.actRows);
        return true;
    }
}

