/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.spreadsheettable;

import adams.core.Properties;
import adams.core.io.PlaceholderFile;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.gui.core.GUIHelper;
import adams.gui.core.PropertiesParameterPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.AbstractProcessRow;
import adams.gui.core.spreadsheettable.SpreadSheetTablePopupMenuItemHelper;
import adams.gui.dialog.PropertiesParameterDialog;
import adams.gui.dialog.SimplePreviewBrowserDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;

public class PreviewSelectedFile
extends AbstractProcessRow {
    private static final long serialVersionUID = 7786133414905315983L;
    public static final String KEY_COLUMNS = "column";

    public String globalInfo() {
        return "Allows the user to preview the selected file in the specified column.";
    }

    public String getIconName() {
        return "previewbrowser.png";
    }

    public String getMenuItem() {
        return "Preview selected file";
    }

    protected Properties promptParameters(SpreadSheetTable table) {
        PropertiesParameterDialog dialog = GUIHelper.getParentDialog((Container)table) != null ? new PropertiesParameterDialog(GUIHelper.getParentDialog((Container)table), Dialog.ModalityType.DOCUMENT_MODAL) : new PropertiesParameterDialog(GUIHelper.getParentFrame((Container)table), true);
        PropertiesParameterPanel panel = dialog.getPropertiesParameterPanel();
        panel.addPropertyType(KEY_COLUMNS, PropertiesParameterPanel.PropertyType.INDEX);
        panel.setLabel(KEY_COLUMNS, "Column");
        panel.setHelp(KEY_COLUMNS, "The column containing the file name");
        Properties last = new Properties();
        last.setProperty(KEY_COLUMNS, "first");
        dialog.setProperties(last);
        last = (Properties)table.getLastSetup(((Object)((Object)this)).getClass(), true, true);
        if (last != null) {
            dialog.setProperties(last);
        }
        dialog.setTitle(this.getMenuItem());
        dialog.pack();
        dialog.setLocationRelativeTo((Component)table.getParent());
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return null;
        }
        return dialog.getProperties();
    }

    protected boolean doProcessRow(SpreadSheetTablePopupMenuItemHelper.TableState state) {
        Properties last = this.promptParameters(state.table);
        if (last == null) {
            return false;
        }
        SpreadSheet sheet = state.table.toSpreadSheet(state.range, true);
        SpreadSheetColumnIndex column = new SpreadSheetColumnIndex(last.getProperty(KEY_COLUMNS, "first"));
        column.setData(sheet);
        int col = column.getIntIndex();
        if (col == -1) {
            GUIHelper.showErrorMessage((Component)state.table.getParent(), (String)("Failed to locate column:" + column));
            return false;
        }
        state.table.addLastSetup(((Object)((Object)this)).getClass(), false, true, (Object)last);
        SimplePreviewBrowserDialog dialog = new SimplePreviewBrowserDialog();
        dialog.open(new PlaceholderFile(sheet.getCell(state.actRow, col).toString()));
        dialog.setLocationRelativeTo((Component)state.table.getParent());
        dialog.setVisible(true);
        dialog.setDefaultCloseOperation(2);
        return true;
    }
}

