/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.dialog;

import adams.core.AdditionalInformationHandler;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.ImageManager;
import adams.gui.core.RecentSpreadSheetQueriesHandler;
import adams.gui.core.SpreadSheetQueryEditorPanel;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.help.HelpFrame;
import adams.parser.SpreadSheetQuery;
import adams.parser.SpreadSheetQueryText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SpreadSheetQueryPanel
extends BasePanel {
    private static final long serialVersionUID = -4419661519749458767L;
    public static final String SESSION_FILE = "SpreadSheetQueries.props";
    protected SpreadSheetQueryEditorPanel m_PanelQuery;
    protected BaseButton m_ButtonOptions;
    protected BaseButton m_ButtonHelp;
    protected JPanel m_PanelBottom;
    protected JPanel m_PanelButtonsRight;
    protected JPanel m_PanelButtonsLeft;
    protected BaseButton m_ButtonHistory;
    protected JPopupMenu m_PopupMenu;
    protected RecentSpreadSheetQueriesHandler<JPopupMenu> m_RecentStatementsHandler;
    protected Set<ChangeListener> m_QueryChangeListeners;

    protected void initialize() {
        super.initialize();
        this.m_QueryChangeListeners = new HashSet<ChangeListener>();
    }

    protected void initGUI() {
        this.m_PanelQuery = new SpreadSheetQueryEditorPanel();
        this.m_PanelQuery.setWordWrap(true);
        this.m_PanelQuery.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SpreadSheetQueryPanel.this.notfyQueryChangeListeners();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SpreadSheetQueryPanel.this.notfyQueryChangeListeners();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SpreadSheetQueryPanel.this.notfyQueryChangeListeners();
            }
        });
        this.add((Component)((Object)this.m_PanelQuery), "Center");
        this.m_PanelBottom = new JPanel(new BorderLayout());
        this.add(this.m_PanelBottom, "South");
        this.m_PanelButtonsLeft = new JPanel(new FlowLayout(0));
        this.m_PanelBottom.add((Component)this.m_PanelButtonsLeft, "West");
        this.m_ButtonOptions = new BaseButton((Icon)ImageManager.getIcon((String)"arrow-head-down.png"));
        this.m_ButtonOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JPopupMenu menu = new JPopupMenu();
                JMenuItem menuitem = new JMenuItem("Cut");
                menuitem.setIcon(ImageManager.getIcon((String)"cut.gif"));
                menuitem.setEnabled(SpreadSheetQueryPanel.this.m_PanelQuery.canCut());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SpreadSheetQueryPanel.this.m_PanelQuery.cut();
                    }
                });
                menu.add(menuitem);
                menuitem = new JMenuItem("Copy");
                menuitem.setIcon(ImageManager.getIcon((String)"copy.gif"));
                menuitem.setEnabled(SpreadSheetQueryPanel.this.m_PanelQuery.canCopy());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SpreadSheetQueryPanel.this.m_PanelQuery.copy();
                    }
                });
                menu.add(menuitem);
                menuitem = new JMenuItem("Paste");
                menuitem.setIcon(ImageManager.getIcon((String)"paste.gif"));
                menuitem.setEnabled(SpreadSheetQueryPanel.this.m_PanelQuery.canPaste());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SpreadSheetQueryPanel.this.m_PanelQuery.paste();
                    }
                });
                menu.add(menuitem);
                menuitem = new JCheckBoxMenuItem("Line wrap");
                menuitem.setSelected(SpreadSheetQueryPanel.this.m_PanelQuery.getWordWrap());
                menuitem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SpreadSheetQueryPanel.this.m_PanelQuery.setWordWrap(((JMenuItem)e.getSource()).isSelected());
                    }
                });
                menu.addSeparator();
                menu.add(menuitem);
                menu.show((Component)SpreadSheetQueryPanel.this.m_ButtonOptions, 0, SpreadSheetQueryPanel.this.m_ButtonOptions.getHeight());
            }
        });
        this.m_PanelButtonsLeft.add((Component)this.m_ButtonOptions);
        this.m_ButtonHistory = new BaseButton((Icon)ImageManager.getIcon((String)"history.png"));
        this.m_ButtonHistory.setToolTipText("Recent queries");
        this.m_ButtonHistory.setVisible(false);
        this.m_ButtonHistory.addActionListener(e -> this.m_PopupMenu.show((Component)this.m_ButtonHistory, 0, this.m_ButtonHistory.getHeight()));
        this.m_PanelButtonsLeft.add((Component)this.m_ButtonHistory);
        this.m_PopupMenu = new JPopupMenu();
        this.m_RecentStatementsHandler = new RecentSpreadSheetQueriesHandler<JPopupMenu>(SESSION_FILE, 10, this.m_PopupMenu);
        this.m_RecentStatementsHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JPopupMenu, SpreadSheetQueryText>(){

            public void recentItemAdded(RecentItemEvent<JPopupMenu, SpreadSheetQueryText> e) {
            }

            public void recentItemSelected(RecentItemEvent<JPopupMenu, SpreadSheetQueryText> e) {
                SpreadSheetQueryPanel.this.setQuery((SpreadSheetQueryText)((Object)e.getItem()));
            }
        });
        this.m_PanelButtonsRight = new JPanel(new FlowLayout(2));
        this.m_PanelBottom.add((Component)this.m_PanelButtonsRight, "East");
        if (this.m_PanelQuery instanceof AdditionalInformationHandler) {
            this.m_ButtonHelp = new BaseButton((Icon)ImageManager.getIcon((String)"help.gif"));
            this.m_ButtonHelp.addActionListener(e -> {
                String help = this.m_PanelQuery.getAdditionalInformation();
                HelpFrame.showHelp(SpreadSheetQuery.class, (String)help, (boolean)false);
            });
            this.m_PanelButtonsRight.add((Component)this.m_ButtonHelp);
        }
    }

    public void setQuery(SpreadSheetQueryText value) {
        this.m_PanelQuery.setContent(value.getValue());
    }

    public SpreadSheetQueryText getQuery() {
        return new SpreadSheetQueryText(this.m_PanelQuery.getContent());
    }

    public void addQueryChangeListener(ChangeListener l) {
        this.m_QueryChangeListeners.add(l);
    }

    public void removeQueryChangeListener(ChangeListener l) {
        this.m_QueryChangeListeners.remove(l);
    }

    protected void notfyQueryChangeListeners() {
        ChangeEvent e = new ChangeEvent((Object)this);
        for (ChangeListener l : this.m_QueryChangeListeners) {
            l.stateChanged(e);
        }
    }

    public SpreadSheetQueryEditorPanel getQueryPanel() {
        return this.m_PanelQuery;
    }

    public JPanel getButtonsLeft() {
        return this.m_PanelButtonsLeft;
    }

    public JPanel getButtonsRight() {
        return this.m_PanelButtonsRight;
    }

    public void setHistoryVisible(boolean value) {
        this.m_ButtonHistory.setVisible(value);
    }

    public boolean isHistoryVisible() {
        return this.m_ButtonHistory.isVisible();
    }

    public void addToHistory() {
        this.m_RecentStatementsHandler.addRecentItem((Object)this.getQuery());
    }
}

