/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.MessageCollection;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.data.io.input.AbstractObjectReader;
import adams.data.io.output.AbstractObjectWriter;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Actor;
import adams.gui.application.ChildFrame;
import adams.gui.chooser.SerializationFileChooser;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseStatusBar;
import adams.gui.core.BaseTable;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.SpreadSheetTableWithSearch;
import adams.gui.core.UISettings;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.event.SpreadSheetProcessorListener;
import adams.gui.tools.spreadsheetprocessor.AbstractWidget;
import adams.gui.tools.spreadsheetprocessor.processors.AbstractProcessor;
import adams.gui.tools.spreadsheetprocessor.processors.QueryProcessor;
import adams.gui.tools.spreadsheetprocessor.sources.AbstractSource;
import adams.gui.tools.spreadsheetprocessor.sources.FileSource;
import adams.gui.tools.spreadsheetprocessor.targets.AbstractTarget;
import adams.gui.tools.spreadsheetprocessor.targets.FileTarget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;
import nz.ac.waikato.cms.locator.ClassLocator;

public class SpreadSheetProcessorPanel
extends BasePanel
implements MenuBarProvider,
SpreadSheetProcessorListener,
CleanUpHandler {
    private static final long serialVersionUID = -8779070213062972306L;
    public static final String KEY_SOURCE_DATA = "source.data";
    public static final String KEY_PROCESSOR_DATA = "processor.data";
    public static final String KEY_TARGET_DATA = "target.data";
    public static final String KEY_SOURCE_NAME = "source.name";
    public static final String KEY_PROCESSOR_NAME = "processor.name";
    public static final String KEY_TARGET_NAME = "target.name";
    protected BaseSplitPane m_SplitPanelVert1;
    protected BaseSplitPane m_SplitPanelVert2;
    protected BaseSplitPane m_SplitPanelLeft;
    protected BaseSplitPane m_SplitPanelCenter;
    protected BaseSplitPane m_SplitPanelRight;
    protected WidgetPanel m_PanelSource;
    protected SpreadSheetTableWithSearch m_TableSource;
    protected SpreadSheetTableModel m_TableModelSource;
    protected WidgetPanel m_PanelProcessor;
    protected SpreadSheetTableWithSearch m_TableProcessor;
    protected SpreadSheetTableModel m_TableModelProcessor;
    protected WidgetPanel m_PanelTarget;
    protected JMenuBar m_MenuBar;
    protected BaseStatusBar m_StatusBar;
    protected SpreadSheet m_DataSource;
    protected SpreadSheet m_DataProcessor;
    protected List<Actor> m_GeneratedFlows;
    protected SerializationFileChooser m_FileChooserConfiguration;

    protected void initialize() {
        super.initialize();
        this.m_GeneratedFlows = new ArrayList<Actor>();
        this.m_DataSource = null;
        this.m_DataProcessor = null;
        this.m_FileChooserConfiguration = new SerializationFileChooser();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelSource = new WidgetPanel(this, "Source", AbstractSource.class, new FileSource());
        this.m_PanelProcessor = new WidgetPanel(this, "Processor", AbstractProcessor.class, new QueryProcessor());
        this.m_PanelTarget = new WidgetPanel(this, "Target", AbstractTarget.class, new FileTarget());
        this.m_TableModelSource = new SpreadSheetTableModel((SpreadSheet)new DefaultSpreadSheet());
        this.m_TableModelSource.setReadOnly(true);
        this.m_TableSource = new SpreadSheetTableWithSearch(this.m_TableModelSource);
        this.m_TableSource.setColumnWidthApproach(BaseTable.ColumnWidthApproach.ADAPTIVE);
        this.m_TableSource.setColumnsDropdownVisible(true);
        this.m_TableModelProcessor = new SpreadSheetTableModel((SpreadSheet)new DefaultSpreadSheet());
        this.m_TableModelProcessor.setReadOnly(true);
        this.m_TableProcessor = new SpreadSheetTableWithSearch(this.m_TableModelProcessor);
        this.m_TableProcessor.setColumnWidthApproach(BaseTable.ColumnWidthApproach.ADAPTIVE);
        this.m_TableProcessor.setColumnsDropdownVisible(true);
        this.m_SplitPanelLeft = new BaseSplitPane(0);
        this.m_SplitPanelLeft.setOneTouchExpandable(true);
        this.m_SplitPanelLeft.setResizeWeight(0.5);
        this.m_SplitPanelLeft.setDividerLocation(UISettings.get(this.getClass(), (String)"DividerLeft", (int)300));
        this.m_SplitPanelLeft.setUISettingsParameters(this.getClass(), "DividerLeft");
        this.m_SplitPanelLeft.setTopComponent((Component)((Object)this.m_PanelSource));
        this.m_SplitPanelLeft.setBottomComponent((Component)this.m_TableSource);
        this.m_SplitPanelCenter = new BaseSplitPane(0);
        this.m_SplitPanelCenter.setOneTouchExpandable(true);
        this.m_SplitPanelCenter.setResizeWeight(0.5);
        this.m_SplitPanelCenter.setDividerLocation(UISettings.get(this.getClass(), (String)"DividerCenter", (int)300));
        this.m_SplitPanelCenter.setUISettingsParameters(this.getClass(), "DividerCenter");
        this.m_SplitPanelCenter.setTopComponent((Component)((Object)this.m_PanelProcessor));
        this.m_SplitPanelCenter.setBottomComponent((Component)this.m_TableProcessor);
        this.m_SplitPanelRight = new BaseSplitPane(0);
        this.m_SplitPanelRight.setOneTouchExpandable(true);
        this.m_SplitPanelRight.setResizeWeight(0.5);
        this.m_SplitPanelRight.setDividerLocation(UISettings.get(this.getClass(), (String)"DividerRight", (int)300));
        this.m_SplitPanelRight.setUISettingsParameters(this.getClass(), "DividerRight");
        this.m_SplitPanelRight.setTopComponent((Component)((Object)this.m_PanelTarget));
        this.m_SplitPanelVert2 = new BaseSplitPane(1);
        this.m_SplitPanelVert2.setOneTouchExpandable(true);
        this.m_SplitPanelVert2.setResizeWeight(0.5);
        this.m_SplitPanelVert2.setDividerLocation(UISettings.get(this.getClass(), (String)"DividerVert2", (int)300));
        this.m_SplitPanelVert2.setUISettingsParameters(this.getClass(), "DividerVert2");
        this.m_SplitPanelVert2.setLeftComponent((Component)this.m_SplitPanelCenter);
        this.m_SplitPanelVert2.setRightComponent((Component)this.m_SplitPanelRight);
        this.m_SplitPanelVert1 = new BaseSplitPane(1);
        this.m_SplitPanelVert1.setOneTouchExpandable(true);
        this.m_SplitPanelVert1.setResizeWeight(0.33);
        this.m_SplitPanelVert1.setDividerLocation(UISettings.get(this.getClass(), (String)"DividerVert1", (int)300));
        this.m_SplitPanelVert1.setUISettingsParameters(this.getClass(), "DividerVert1");
        this.m_SplitPanelVert1.setLeftComponent((Component)this.m_SplitPanelLeft);
        this.m_SplitPanelVert1.setRightComponent((Component)this.m_SplitPanelVert2);
        this.add((Component)this.m_SplitPanelVert1, "Center");
        this.m_StatusBar = new BaseStatusBar();
        this.m_StatusBar.setMouseListenerActive(true);
        this.add((Component)this.m_StatusBar, "South");
    }

    protected void finishInit() {
        super.finishInit();
        this.getSourceWidget().update();
        this.getProcessorWidget().update();
        this.getTargetWidget().update();
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(e -> this.updateMenu());
            JMenuItem menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(ImageManager.getIcon((String)"exit.png"));
            menuitem.addActionListener(e -> this.closeParent());
            menu = new JMenu("Configuration");
            result.add(menu);
            menu.setMnemonic('C');
            menu.addChangeListener(e -> this.updateMenu());
            menuitem = new JMenuItem("Open...", ImageManager.getIcon((String)"open.gif"));
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.addActionListener(e -> this.openConfiguration());
            menuitem = new JMenuItem("Save...", ImageManager.getIcon((String)"save.gif"));
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.addActionListener(e -> this.saveConfiguration());
            menu = new JMenu("Window");
            result.add(menu);
            menu.setMnemonic('W');
            menu.addChangeListener(e -> this.updateMenu());
            menuitem = new JMenuItem("New window");
            menu.add(menuitem);
            menuitem.setMnemonic('N');
            menuitem.addActionListener(e -> this.newWindow());
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateMenu() {
    }

    protected void openConfiguration() {
        Object data;
        int retVal = this.m_FileChooserConfiguration.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        PlaceholderFile file = this.m_FileChooserConfiguration.getSelectedPlaceholderFile();
        AbstractObjectReader reader = this.m_FileChooserConfiguration.getObjectReader();
        Object msg = null;
        try {
            data = reader.read(file);
        }
        catch (Exception e) {
            msg = "Failed to load configuration from: " + file + "\n" + LoggingHelper.throwableToString((Throwable)e);
            data = null;
        }
        if (data != null) {
            if (data instanceof Map) {
                MessageCollection errors = new MessageCollection();
                Map map = (Map)data;
                if (map.containsKey(KEY_SOURCE_NAME) && map.containsKey(KEY_SOURCE_DATA) && this.selectSourceWidget((String)map.get(KEY_SOURCE_NAME))) {
                    this.getSourceWidget().deserialize(map.get(KEY_SOURCE_DATA), errors);
                }
                if (map.containsKey(KEY_PROCESSOR_NAME) && map.containsKey(KEY_PROCESSOR_DATA) && this.selectProcessorWidget((String)map.get(KEY_PROCESSOR_NAME))) {
                    this.getProcessorWidget().deserialize(map.get(KEY_PROCESSOR_DATA), errors);
                }
                if (map.containsKey(KEY_TARGET_NAME) && map.containsKey(KEY_TARGET_DATA) && this.selectTargetWidget((String)map.get(KEY_TARGET_NAME))) {
                    this.getTargetWidget().deserialize(map.get(KEY_TARGET_DATA), errors);
                }
                if (!errors.isEmpty()) {
                    msg = errors.toString();
                }
            } else {
                msg = "Data loaded from '" + file + "' does not represent a map!";
            }
        }
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)msg);
        } else {
            this.m_StatusBar.showStatus("Configuration loaded from: " + file);
        }
    }

    protected void saveConfiguration() {
        Object msg;
        int retVal = this.m_FileChooserConfiguration.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        PlaceholderFile file = this.m_FileChooserConfiguration.getSelectedPlaceholderFile();
        AbstractObjectWriter writer = this.m_FileChooserConfiguration.getObjectWriter();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(KEY_SOURCE_NAME, this.getSourceWidget().getName());
        map.put(KEY_SOURCE_DATA, this.getSourceWidget().serialize());
        map.put(KEY_PROCESSOR_NAME, this.getProcessorWidget().getName());
        map.put(KEY_PROCESSOR_DATA, this.getProcessorWidget().serialize());
        map.put(KEY_TARGET_NAME, this.getTargetWidget().getName());
        map.put(KEY_TARGET_DATA, this.getTargetWidget().serialize());
        try {
            msg = writer.write(file, map);
        }
        catch (Exception e) {
            msg = "Failed to save configuration to: " + file + "\n" + LoggingHelper.throwableToString((Throwable)e);
        }
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)msg);
        } else {
            this.m_StatusBar.showStatus("Configuration saved to: " + file);
        }
    }

    public boolean selectSourceWidget(String name) {
        return this.m_PanelSource.selectCurrentWidget(name);
    }

    public void setSourceWidget(AbstractSource value) {
        this.m_PanelSource.setCurrentWidget(value);
        this.m_PanelSource.update();
    }

    public AbstractSource getSourceWidget() {
        return (AbstractSource)this.m_PanelSource.getCurrentWidget();
    }

    public boolean selectProcessorWidget(String name) {
        return this.m_PanelProcessor.selectCurrentWidget(name);
    }

    public void setProcessorWidget(AbstractProcessor value) {
        this.m_PanelProcessor.setCurrentWidget(value);
        this.m_PanelProcessor.update();
    }

    public AbstractProcessor getProcessorWidget() {
        return (AbstractProcessor)this.m_PanelProcessor.getCurrentWidget();
    }

    public boolean selectTargetWidget(String name) {
        return this.m_PanelTarget.selectCurrentWidget(name);
    }

    public void setTargetWidget(AbstractTarget value) {
        this.m_PanelTarget.setCurrentWidget(value);
        this.m_PanelTarget.update();
    }

    public AbstractTarget getTargetWidget() {
        return (AbstractTarget)this.m_PanelTarget.getCurrentWidget();
    }

    public SpreadSheet getSourceData() {
        return this.m_DataSource;
    }

    public SpreadSheet getProcessorData() {
        return this.m_DataProcessor;
    }

    public SpreadSheetProcessorPanel newWindow() {
        SpreadSheetProcessorPanel result = null;
        ChildFrame oldFrame = (ChildFrame)GUIHelper.getParent((Container)((Object)this), ChildFrame.class);
        if (oldFrame != null) {
            ChildFrame newFrame = oldFrame.getNewWindow();
            newFrame.setVisible(true);
            result = (SpreadSheetProcessorPanel)((Object)newFrame.getContentPane().getComponent(0));
        }
        if (result != null) {
            result.setSourceWidget(this.getSourceWidget());
            result.setProcessorWidget(this.getProcessorWidget());
            result.setTargetWidget(this.getTargetWidget());
        }
        return result;
    }

    @Override
    public void processorStateChanged(SpreadSheetProcessorEvent e) {
        this.m_StatusBar.setStatus(e.getMessage() == null ? "" : e.getMessage());
        switch (e.getType()) {
            case DATA_IS_AVAILABLE: {
                SwingWorker worker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        AbstractSource widget = SpreadSheetProcessorPanel.this.getSourceWidget();
                        if (widget.hasData()) {
                            SpreadSheetProcessorPanel.this.m_DataSource = widget.getData();
                            SpreadSheetProcessorPanel.this.m_DataProcessor = null;
                            SpreadSheetProcessorPanel.this.m_TableModelSource = new SpreadSheetTableModel(SpreadSheetProcessorPanel.this.m_DataSource);
                            SpreadSheetProcessorPanel.this.m_TableSource.setModel((TableModel)SpreadSheetProcessorPanel.this.m_TableModelSource);
                        } else {
                            SpreadSheetProcessorPanel.this.m_DataSource = null;
                            SpreadSheetProcessorPanel.this.m_DataProcessor = null;
                            SpreadSheetProcessorPanel.this.m_TableModelSource = new SpreadSheetTableModel();
                            SpreadSheetProcessorPanel.this.m_TableSource.setModel((TableModel)SpreadSheetProcessorPanel.this.m_TableModelSource);
                        }
                        SpreadSheetProcessorPanel.this.getProcessorWidget().update();
                        SpreadSheetProcessorPanel.this.getTargetWidget().update();
                        return null;
                    }
                };
                worker.execute();
                break;
            }
            case PROCESS_DATA: {
                SwingWorker worker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        AbstractProcessor widget = SpreadSheetProcessorPanel.this.getProcessorWidget();
                        MessageCollection errors = new MessageCollection();
                        if (SpreadSheetProcessorPanel.this.m_DataSource != null) {
                            SpreadSheetProcessorPanel.this.m_DataProcessor = widget.process(SpreadSheetProcessorPanel.this.m_DataSource, errors);
                            if (errors.isEmpty()) {
                                SpreadSheetProcessorPanel.this.m_TableModelProcessor = new SpreadSheetTableModel(SpreadSheetProcessorPanel.this.m_DataProcessor);
                                SpreadSheetProcessorPanel.this.m_TableProcessor.setModel((TableModel)SpreadSheetProcessorPanel.this.m_TableModelProcessor);
                            } else {
                                SpreadSheetProcessorPanel.this.m_DataProcessor = null;
                                SpreadSheetProcessorPanel.this.m_TableModelProcessor = new SpreadSheetTableModel();
                                SpreadSheetProcessorPanel.this.m_TableProcessor.setModel((TableModel)SpreadSheetProcessorPanel.this.m_TableModelProcessor);
                            }
                            SpreadSheetProcessorPanel.this.getTargetWidget().update();
                        }
                        if (!errors.isEmpty()) {
                            GUIHelper.showErrorMessage((Component)((Object)SpreadSheetProcessorPanel.this), (String)errors.toString());
                        }
                        return null;
                    }
                };
                worker.execute();
                break;
            }
            case OUTPUT_DATA: {
                SwingWorker worker = new SwingWorker(){

                    protected Object doInBackground() throws Exception {
                        AbstractTarget widget = SpreadSheetProcessorPanel.this.getTargetWidget();
                        MessageCollection errors = new MessageCollection();
                        if (SpreadSheetProcessorPanel.this.m_DataProcessor != null) {
                            widget.process(SpreadSheetProcessorPanel.this.m_DataProcessor, errors);
                            if (errors.isEmpty()) {
                                SpreadSheetProcessorPanel.this.m_SplitPanelRight.setBottomComponentHidden(true);
                            }
                        }
                        if (!errors.isEmpty()) {
                            GUIHelper.showErrorMessage((Component)((Object)SpreadSheetProcessorPanel.this), (String)errors.toString());
                        }
                        return null;
                    }
                };
                worker.execute();
            }
        }
    }

    public void addGeneratedFlow(Actor flow) {
        this.m_GeneratedFlows.add(flow);
    }

    public void cleanUp() {
        for (Actor flow : this.m_GeneratedFlows) {
            flow.destroy();
        }
        this.m_GeneratedFlows.clear();
    }

    public static class WidgetPanel
    extends BasePanel {
        private static final long serialVersionUID = -2509485998585342076L;
        protected SpreadSheetProcessorPanel m_Owner;
        protected String m_Label;
        protected Class m_WidgetClass;
        protected AbstractWidget m_DefaultWidget;
        protected List<AbstractWidget> m_Widgets;
        protected BaseComboBox<AbstractWidget> m_ComboBoxWidgets;
        protected BasePanel m_PanelWidget;
        protected AbstractWidget m_CurrentWidget;

        public WidgetPanel(SpreadSheetProcessorPanel owner, String label, Class widgetClass, AbstractWidget defaultWidget) {
            this.m_Owner = owner;
            this.m_Label = label;
            this.m_WidgetClass = widgetClass;
            this.m_DefaultWidget = defaultWidget;
            this.m_CurrentWidget = null;
            this.initGUI();
            this.finishInit();
        }

        protected void initGUI() {
            if (this.m_WidgetClass == null) {
                return;
            }
            super.initGUI();
            Class[] classes = ClassLister.getSingleton().getClasses(this.m_WidgetClass);
            this.m_Widgets = new ArrayList<AbstractWidget>();
            for (Class cls : classes) {
                try {
                    AbstractWidget widget = (AbstractWidget)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    widget.setOwner(this.m_Owner);
                    this.m_Widgets.add(widget);
                }
                catch (Exception e2) {
                    ConsolePanel.getSingleton().append("Failed to instantiate: " + cls.getName(), (Throwable)e2);
                }
            }
            Collections.sort(this.m_Widgets);
            this.m_ComboBoxWidgets = new BaseComboBox(this.m_Widgets);
            this.m_ComboBoxWidgets.addActionListener(e -> this.update());
            JPanel panel = new JPanel(new FlowLayout(0));
            this.add(panel, "North");
            JLabel label = new JLabel(this.m_Label);
            label.setLabelFor((Component)this.m_ComboBoxWidgets);
            panel.add(label);
            panel.add((Component)this.m_ComboBoxWidgets);
            this.m_PanelWidget = new BasePanel((LayoutManager)new BorderLayout());
            this.add((Component)this.m_PanelWidget, "Center");
        }

        protected void finishInit() {
            if (this.m_WidgetClass == null) {
                return;
            }
            super.finishInit();
            this.m_ComboBoxWidgets.setSelectedItem((Object)this.m_DefaultWidget);
        }

        protected void update() {
            if (this.m_ComboBoxWidgets.getSelectedIndex() < 0) {
                return;
            }
            this.m_CurrentWidget = (AbstractWidget)this.m_ComboBoxWidgets.getSelectedItem();
            this.m_PanelWidget.removeAll();
            if (this.m_CurrentWidget.getWidget() != null) {
                this.m_PanelWidget.add(this.m_CurrentWidget.getWidget(), (Object)"Center");
            }
            this.m_PanelWidget.invalidate();
            this.m_PanelWidget.revalidate();
            this.m_PanelWidget.repaint();
        }

        public AbstractWidget getCurrentWidget() {
            return this.m_CurrentWidget;
        }

        public boolean selectCurrentWidget(String name) {
            for (AbstractWidget widget : this.m_Widgets) {
                if (!widget.getName().equals(name)) continue;
                this.setCurrentWidget(widget);
                return true;
            }
            return false;
        }

        public void setCurrentWidget(AbstractWidget value) {
            if (ClassLocator.isSubclass((Class)this.m_WidgetClass, value.getClass())) {
                for (int i = 0; i < this.m_Widgets.size(); ++i) {
                    if (!this.m_Widgets.get(i).equals(value)) continue;
                    this.m_Widgets.get(i).assign(value);
                    this.m_ComboBoxWidgets.setSelectedIndex(i);
                    break;
                }
            }
        }
    }
}

