/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetprocessor.processors;

import adams.core.MessageCollection;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BaseButton;
import adams.gui.core.ImageManager;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.tools.spreadsheetprocessor.AbstractWidget;
import adams.gui.tools.spreadsheetprocessor.processors.AbstractProcessor;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JPanel;

public class PassThroughProcessor
extends AbstractProcessor {
    private static final long serialVersionUID = 2926743330826433963L;
    protected JPanel m_Panel;
    protected BaseButton m_ButtonExecute;

    @Override
    public String getName() {
        return "Passthrough";
    }

    @Override
    public Component getWidget() {
        if (this.m_Panel == null) {
            this.m_Panel = new JPanel(new FlowLayout(0));
            this.m_ButtonExecute = new BaseButton((Icon)ImageManager.getIcon((String)"run.gif"));
            this.m_ButtonExecute.addActionListener(e -> this.execute());
            this.m_ButtonExecute.setToolTipText("Passes through the data (Alt+X)");
            this.m_Panel.add((Component)this.m_ButtonExecute);
        }
        return this.m_Panel;
    }

    protected void execute() {
        this.notifyOwner(SpreadSheetProcessorEvent.EventType.PROCESS_DATA, "Pass through data");
    }

    @Override
    public void assign(AbstractWidget other) {
        if (other instanceof PassThroughProcessor) {
            PassThroughProcessor widget = (PassThroughProcessor)other;
            widget.getWidget();
        }
    }

    @Override
    public Object serialize() {
        return new HashMap();
    }

    @Override
    public void deserialize(Object data, MessageCollection errors) {
    }

    @Override
    public void update() {
        this.m_ButtonExecute.setEnabled(this.m_Owner.getSourceData() != null);
    }

    @Override
    protected SpreadSheet doProcess(SpreadSheet data, MessageCollection errors) {
        this.notifyOwner(SpreadSheetProcessorEvent.EventType.DATA_IS_PROCESSED, "Passed through data");
        return data;
    }
}

