/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetprocessor.processors;

import adams.core.MessageCollection;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BaseButton;
import adams.gui.core.ImageManager;
import adams.gui.dialog.SpreadSheetQueryPanel;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.tools.spreadsheetprocessor.AbstractWidget;
import adams.gui.tools.spreadsheetprocessor.processors.AbstractProcessor;
import adams.parser.SpreadSheetQuery;
import adams.parser.SpreadSheetQueryText;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class QueryProcessor
extends AbstractProcessor {
    private static final long serialVersionUID = 2926743330826433963L;
    public static final String KEY_QUERY = "query";
    protected SpreadSheetQueryPanel m_PanelQuery;
    protected BaseButton m_ButtonExecute;

    @Override
    public String getName() {
        return "Query";
    }

    @Override
    public Component getWidget() {
        if (this.m_PanelQuery == null) {
            this.m_PanelQuery = new SpreadSheetQueryPanel();
            this.m_PanelQuery.setHistoryVisible(true);
            this.m_PanelQuery.addQueryChangeListener(e -> this.update());
            this.m_PanelQuery.getQueryPanel().getTextPane().addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 88 && e.getModifiersEx() == 512) {
                        e.consume();
                        QueryProcessor.this.execute();
                    }
                    if (!e.isConsumed()) {
                        super.keyPressed(e);
                    }
                }
            });
            this.m_ButtonExecute = new BaseButton((Icon)ImageManager.getIcon((String)"run.gif"));
            this.m_ButtonExecute.addActionListener(e -> this.execute());
            this.m_ButtonExecute.setToolTipText("Executes the query (Alt+X)");
            this.m_PanelQuery.getButtonsRight().add((Component)this.m_ButtonExecute);
        }
        return this.m_PanelQuery;
    }

    protected void execute() {
        this.notifyOwner(SpreadSheetProcessorEvent.EventType.PROCESS_DATA, "Execute query: " + this.m_PanelQuery.getQuery().getValue());
    }

    public void setCurrentQuery(SpreadSheetQueryText value) {
        this.m_PanelQuery.setQuery(value);
    }

    public SpreadSheetQueryText getCurrentQuery() {
        return this.m_PanelQuery.getQuery();
    }

    @Override
    public void assign(AbstractWidget other) {
        if (other instanceof QueryProcessor) {
            QueryProcessor widget = (QueryProcessor)other;
            widget.getWidget();
            this.setCurrentQuery(widget.getCurrentQuery());
        }
    }

    @Override
    public Object serialize() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(KEY_QUERY, this.getCurrentQuery().getValue());
        return result;
    }

    @Override
    public void deserialize(Object data, MessageCollection errors) {
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.containsKey(KEY_QUERY)) {
                this.setCurrentQuery(new SpreadSheetQueryText((String)map.get(KEY_QUERY)));
            }
            this.update();
        } else {
            errors.add(this.getClass().getName() + ": Deserialization data is not a map!");
        }
    }

    @Override
    public void update() {
        this.m_ButtonExecute.setEnabled(this.m_Owner.getSourceData() != null && !this.getCurrentQuery().isEmpty());
    }

    @Override
    protected SpreadSheet doProcess(SpreadSheet data, MessageCollection errors) {
        SpreadSheet result;
        SpreadSheetQueryText query = this.m_PanelQuery.getQuery();
        if (query.isEmpty()) {
            this.getLogger().warning("No query entered, just passing through the data!");
            result = data;
        } else {
            try {
                result = SpreadSheetQuery.evaluate(query.getValue(), new HashMap(), data);
                this.m_PanelQuery.addToHistory();
                this.notifyOwner(SpreadSheetProcessorEvent.EventType.DATA_IS_PROCESSED, "Executed query: " + query.getValue());
            }
            catch (Exception e) {
                errors.add("Failed to process data using:\n" + query.getValue(), (Throwable)e);
                result = null;
            }
        }
        return result;
    }
}

