/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetprocessor.sources;

import adams.core.MessageCollection;
import adams.core.base.BasePassword;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.DenseDataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.AbstractTypeMapper;
import adams.data.spreadsheet.sql.DefaultTypeMapper;
import adams.data.spreadsheet.sql.Reader;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.SQLF;
import adams.db.SQLStatement;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.core.ParameterPanel;
import adams.gui.core.SqlConnectionPanel;
import adams.gui.dialog.SQLStatementPanel;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.spreadsheetprocessor.AbstractWidget;
import adams.gui.tools.spreadsheetprocessor.sources.AbstractSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class DatabaseSource
extends AbstractSource {
    private static final long serialVersionUID = -4475860171792209905L;
    public static final String KEY_URL = "url";
    public static final String KEY_USER = "user";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_QUERY = "query";
    public static final String KEY_TYPEMAPPER = "typemapper";
    public static final String KEY_DATAROW = "datarow";
    protected BasePanel m_Widget;
    protected SqlConnectionPanel m_PanelConnection;
    protected GenericObjectEditorPanel m_PanelTypeMapper;
    protected GenericObjectEditorPanel m_PanelDataRow;
    protected SQLStatementPanel m_PanelQuery;
    protected BaseButton m_ButtonExecute;
    protected SpreadSheet m_Data;

    @Override
    public String getName() {
        return "Database";
    }

    @Override
    public Component getWidget() {
        if (this.m_Widget == null) {
            this.m_Widget = new BasePanel((LayoutManager)new BorderLayout());
            JPanel topPanel = new JPanel(new BorderLayout());
            this.m_Widget.add((Component)topPanel, (Object)"North");
            this.m_PanelConnection = new SqlConnectionPanel();
            this.m_PanelConnection.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            topPanel.add((Component)this.m_PanelConnection, "North");
            ParameterPanel paramsPanel = new ParameterPanel();
            topPanel.add((Component)paramsPanel, "Center");
            this.m_PanelTypeMapper = new GenericObjectEditorPanel(AbstractTypeMapper.class, (Object)new DefaultTypeMapper(), true);
            paramsPanel.addParameter("Type mapper", (Component)this.m_PanelTypeMapper);
            this.m_PanelDataRow = new GenericObjectEditorPanel(DataRow.class, (Object)new DenseDataRow(), true);
            paramsPanel.addParameter("Data row", (Component)this.m_PanelDataRow);
            this.m_PanelQuery = new SQLStatementPanel();
            this.m_PanelQuery.addQueryChangeListener(e -> this.update());
            this.m_Widget.add((Component)this.m_PanelQuery, (Object)"Center");
            this.m_PanelQuery.getQueryPanel().getTextPane().addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 88 && e.getModifiersEx() == 512) {
                        e.consume();
                        DatabaseSource.this.execute();
                    }
                    if (!e.isConsumed()) {
                        super.keyPressed(e);
                    }
                }
            });
            this.m_ButtonExecute = new BaseButton((Icon)ImageManager.getIcon((String)"run.gif"));
            this.m_ButtonExecute.addActionListener(e -> this.execute());
            this.m_ButtonExecute.setToolTipText("Executes the query (Alt+X)");
            this.m_PanelQuery.getButtonsLeft().add((Component)this.m_ButtonExecute);
        }
        return this.m_Widget;
    }

    protected void execute() {
        SwingWorker worker = new SwingWorker(){
            String error;

            protected Object doInBackground() throws Exception {
                DatabaseSource.this.m_ButtonExecute.setEnabled(false);
                String query = DatabaseSource.this.m_PanelQuery.getStatement().getValue();
                SQLF sql = SQLF.getSingleton((AbstractDatabaseConnection)DatabaseSource.this.m_PanelConnection.getDatabaseConnection());
                Reader reader = new Reader((AbstractTypeMapper)((Object)DatabaseSource.this.m_PanelTypeMapper.getCurrent()), DatabaseSource.this.m_PanelDataRow.getCurrent().getClass());
                try {
                    DatabaseSource.this.m_Data = reader.read(sql.getResultSet(query));
                    if (DatabaseSource.this.m_Data == null) {
                        this.error = "Failed to execute query: " + query;
                    } else {
                        DatabaseSource.this.notifyOwner(SpreadSheetProcessorEvent.EventType.DATA_IS_AVAILABLE, "Query executed: " + query);
                    }
                }
                catch (Exception e) {
                    this.error = LoggingHelper.handleException((LoggingSupporter)DatabaseSource.this, (String)("Failed to execute query: " + query), (Throwable)e);
                    DatabaseSource.this.m_Data = null;
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                DatabaseSource.this.m_ButtonExecute.setEnabled(true);
                if (this.error != null) {
                    GUIHelper.showErrorMessage((Component)DatabaseSource.this.m_Widget.getParent(), (String)this.error);
                }
            }
        };
        worker.execute();
    }

    @Override
    public boolean hasData() {
        return this.m_Data != null;
    }

    @Override
    public SpreadSheet getData() {
        return this.m_Data;
    }

    public void setCurrentQuery(SQLStatement value) {
        this.m_PanelQuery.setStatement(value);
    }

    public SQLStatement getCurrentQuery() {
        return this.m_PanelQuery.getStatement();
    }

    public void setCurrentConnection(AbstractDatabaseConnection value) {
        this.m_PanelConnection.setDatabaseConnection(value);
    }

    public AbstractDatabaseConnection getCurrentConnection() {
        return this.m_PanelConnection.getDatabaseConnection();
    }

    public void setCurrentTypeMapper(AbstractTypeMapper value) {
        this.m_PanelTypeMapper.setCurrent((Object)value);
    }

    public AbstractTypeMapper getCurrentTypeMapper() {
        return (AbstractTypeMapper)((Object)this.m_PanelTypeMapper.getCurrent());
    }

    public void setCurrentDataRow(DataRow value) {
        this.m_PanelDataRow.setCurrent((Object)value);
    }

    public DataRow getCurrentDataRow() {
        return (DataRow)this.m_PanelDataRow.getCurrent();
    }

    @Override
    public void assign(AbstractWidget other) {
        if (other instanceof DatabaseSource) {
            DatabaseSource widget = (DatabaseSource)other;
            widget.getWidget();
            this.setCurrentConnection(widget.getCurrentConnection());
            this.setCurrentQuery(widget.getCurrentQuery());
            this.setCurrentTypeMapper(widget.getCurrentTypeMapper());
            this.setCurrentDataRow(widget.getCurrentDataRow());
        }
    }

    @Override
    public Object serialize() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(KEY_URL, this.getCurrentConnection().getURL());
        result.put(KEY_USER, this.getCurrentConnection().getUser());
        result.put(KEY_PASSWORD, this.getCurrentConnection().getPassword().stringValue());
        result.put(KEY_QUERY, this.getCurrentQuery().getValue());
        result.put(KEY_TYPEMAPPER, OptionUtils.getCommandLine((Object)this.m_PanelTypeMapper.getCurrent()));
        result.put(KEY_DATAROW, OptionUtils.getCommandLine((Object)this.m_PanelDataRow.getCurrent()));
        return result;
    }

    @Override
    public void deserialize(Object data, MessageCollection errors) {
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.containsKey(KEY_URL) && map.containsKey(KEY_USER) && map.containsKey(KEY_PASSWORD)) {
                DatabaseConnection conn = new DatabaseConnection((String)map.get(KEY_URL), (String)map.get(KEY_USER), new BasePassword((String)map.get(KEY_PASSWORD)));
                this.setCurrentConnection((AbstractDatabaseConnection)conn);
            }
            if (map.containsKey(KEY_QUERY)) {
                this.setCurrentQuery(new SQLStatement((String)map.get(KEY_QUERY)));
            }
            if (map.containsKey(KEY_TYPEMAPPER)) {
                try {
                    this.setCurrentTypeMapper((AbstractTypeMapper)((Object)OptionUtils.forAnyCommandLine(AbstractTypeMapper.class, (String)((String)map.get(KEY_TYPEMAPPER)))));
                }
                catch (Exception e) {
                    errors.add(this.getClass().getName() + ": Failed to instantiate type mapper from: " + map.get(KEY_TYPEMAPPER));
                }
            }
            if (map.containsKey(KEY_DATAROW)) {
                try {
                    this.setCurrentDataRow((DataRow)OptionUtils.forAnyCommandLine(DataRow.class, (String)((String)map.get(KEY_DATAROW))));
                }
                catch (Exception e) {
                    errors.add(this.getClass().getName() + ": Failed to instantiate data row from: " + map.get(KEY_DATAROW));
                }
            }
            this.update();
        } else {
            errors.add(this.getClass().getName() + ": Deserialization data is not a map!");
        }
    }

    @Override
    public void update() {
        this.m_ButtonExecute.setEnabled(!this.m_PanelQuery.getStatement().isEmpty());
    }
}

