/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetprocessor.targets;

import adams.core.MessageCollection;
import adams.core.option.OptionUtils;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.ImageManager;
import adams.gui.core.ParameterPanel;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.goe.GenericObjectEditorPanel;
import adams.gui.tools.spreadsheetprocessor.AbstractWidget;
import adams.gui.tools.spreadsheetprocessor.targets.AbstractTarget;
import adams.gui.tools.spreadsheetviewer.chart.AbstractChartGenerator;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class ClipboardTarget
extends AbstractTarget {
    private static final long serialVersionUID = 6535516712611654393L;
    public static final String KEY_CHART = "chart";
    protected BasePanel m_Widget;
    protected GenericObjectEditorPanel m_PanelWriter;
    protected BaseButton m_ButtonCopy;

    @Override
    public String getName() {
        return "Clipboard";
    }

    @Override
    public Component getWidget() {
        if (this.m_Widget == null) {
            this.m_Widget = new BasePanel((LayoutManager)new BorderLayout());
            ParameterPanel panelParams = new ParameterPanel();
            this.m_Widget.add((Component)panelParams, (Object)"Center");
            CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
            writer.setSeparator("\\t");
            this.m_PanelWriter = new GenericObjectEditorPanel(SpreadSheetWriter.class, (Object)writer, false);
            panelParams.addParameter("Writer", (Component)this.m_PanelWriter);
            this.m_ButtonCopy = new BaseButton((Icon)ImageManager.getIcon((String)"run.gif"));
            this.m_ButtonCopy.addActionListener(e -> this.copy());
            JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
            panel.add((Component)this.m_ButtonCopy);
            panelParams.addParameter("Copy", (Component)panel);
        }
        return this.m_Widget;
    }

    @Override
    public void update() {
        this.m_ButtonCopy.setEnabled(this.m_Owner.getProcessorData() != null);
    }

    public void setCurrentWriter(SpreadSheetWriter value) {
        this.m_PanelWriter.setCurrent((Object)value);
    }

    public SpreadSheetWriter getCurrentWriter() {
        return (SpreadSheetWriter)this.m_PanelWriter.getCurrent();
    }

    protected void copy() {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ClipboardTarget.this.m_ButtonCopy.setEnabled(false);
                ClipboardTarget.this.m_Owner.processorStateChanged(new SpreadSheetProcessorEvent(ClipboardTarget.this.m_Owner, SpreadSheetProcessorEvent.EventType.OUTPUT_DATA, "Copying to clipboard"));
                return null;
            }

            @Override
            protected void done() {
                super.done();
                ClipboardTarget.this.m_ButtonCopy.setEnabled(true);
            }
        };
        worker.execute();
    }

    @Override
    public void assign(AbstractWidget other) {
        if (other instanceof ClipboardTarget) {
            ClipboardTarget widget = (ClipboardTarget)other;
            widget.getWidget();
            this.setCurrentWriter(widget.getCurrentWriter());
        }
    }

    @Override
    public Object serialize() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(KEY_CHART, OptionUtils.getCommandLine((Object)this.getCurrentWriter()));
        return result;
    }

    @Override
    public void deserialize(Object data, MessageCollection errors) {
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.containsKey(KEY_CHART)) {
                try {
                    this.setCurrentWriter((SpreadSheetWriter)OptionUtils.forAnyCommandLine(AbstractChartGenerator.class, (String)((String)map.get(KEY_CHART))));
                }
                catch (Exception e) {
                    errors.add(this.getClass().getName() + ": Failed to instantiate chart from: " + map.get(KEY_CHART));
                }
            }
            this.update();
        } else {
            errors.add(this.getClass().getName() + ": Deserialization data is not a map!");
        }
    }

    @Override
    protected void doProcess(SpreadSheet data, MessageCollection errors) {
        StringWriter swriter = new StringWriter();
        CsvSpreadSheetWriter writer = (CsvSpreadSheetWriter)this.m_PanelWriter.getCurrent();
        writer.write(data, (Writer)swriter);
        ClipboardHelper.copyToClipboard((String)swriter.toString());
        this.notifyOwner(SpreadSheetProcessorEvent.EventType.DATA_IS_OUTPUT, "Data copied to clipboard");
    }
}

