/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetprocessor.targets;

import adams.core.MessageCollection;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionUtils;
import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.chooser.SpreadSheetFileChooserPanel;
import adams.gui.core.BaseButton;
import adams.gui.core.BasePanel;
import adams.gui.core.ImageManager;
import adams.gui.core.ParameterPanel;
import adams.gui.event.SpreadSheetProcessorEvent;
import adams.gui.tools.spreadsheetprocessor.AbstractWidget;
import adams.gui.tools.spreadsheetprocessor.targets.AbstractTarget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;

public class FileTarget
extends AbstractTarget {
    private static final long serialVersionUID = 6535516712611654393L;
    public static final String KEY_OUTPUT = "output";
    public static final String KEY_WRITER = "writer";
    protected BasePanel m_Widget;
    protected SpreadSheetFileChooserPanel m_PanelOutput;
    protected BaseButton m_ButtonSave;

    @Override
    public String getName() {
        return "File";
    }

    @Override
    public Component getWidget() {
        if (this.m_Widget == null) {
            this.m_Widget = new BasePanel((LayoutManager)new BorderLayout());
            ParameterPanel panelParams = new ParameterPanel();
            this.m_Widget.add((Component)panelParams, (Object)"Center");
            this.m_PanelOutput = new SpreadSheetFileChooserPanel();
            this.m_PanelOutput.setUseSaveDialog(true);
            panelParams.addParameter("Output", (Component)((Object)this.m_PanelOutput));
            this.m_ButtonSave = new BaseButton((Icon)ImageManager.getIcon((String)"run.gif"));
            this.m_ButtonSave.addActionListener(e -> this.save());
            JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
            panel.add((Component)this.m_ButtonSave);
            panelParams.addParameter("Save", (Component)panel);
        }
        return this.m_Widget;
    }

    @Override
    public void update() {
        this.m_ButtonSave.setEnabled(this.m_Owner.getProcessorData() != null);
    }

    protected void save() {
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                FileTarget.this.m_ButtonSave.setEnabled(false);
                FileTarget.this.m_Owner.processorStateChanged(new SpreadSheetProcessorEvent(FileTarget.this.m_Owner, SpreadSheetProcessorEvent.EventType.OUTPUT_DATA, "Saving to file: " + FileTarget.this.m_PanelOutput.getCurrent()));
                return null;
            }

            @Override
            protected void done() {
                super.done();
                FileTarget.this.m_ButtonSave.setEnabled(true);
            }
        };
        worker.execute();
    }

    public void setCurrentFile(File value) {
        this.m_PanelOutput.setCurrent(value);
    }

    public File getCurrentFile() {
        return (File)this.m_PanelOutput.getCurrent();
    }

    public void setCurrentWriter(SpreadSheetWriter writer) {
        this.m_PanelOutput.setWriter(writer);
    }

    public SpreadSheetWriter getCurrentWriter() {
        return this.m_PanelOutput.getWriter();
    }

    @Override
    public void assign(AbstractWidget other) {
        if (other instanceof FileTarget) {
            FileTarget widget = (FileTarget)other;
            widget.getWidget();
            this.setCurrentFile(widget.getCurrentFile());
            this.setCurrentWriter(widget.getCurrentWriter());
        }
    }

    @Override
    public Object serialize() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(KEY_OUTPUT, this.getCurrentFile().getAbsolutePath());
        result.put(KEY_WRITER, OptionUtils.getCommandLine((Object)this.getCurrentWriter()));
        return result;
    }

    @Override
    public void deserialize(Object data, MessageCollection errors) {
        if (data instanceof Map) {
            Map map = (Map)data;
            if (map.containsKey(KEY_OUTPUT)) {
                this.m_PanelOutput.setCurrent((File)new PlaceholderFile((String)map.get(KEY_OUTPUT)));
            }
            if (map.containsKey(KEY_WRITER)) {
                try {
                    this.setCurrentWriter((SpreadSheetWriter)OptionUtils.forAnyCommandLine(SpreadSheetWriter.class, (String)((String)map.get(KEY_WRITER))));
                }
                catch (Exception e) {
                    errors.add(this.getClass().getName() + ": Failed to instantiate writer from: " + map.get(KEY_WRITER));
                }
            }
            this.update();
        } else {
            errors.add(this.getClass().getName() + ": Deserialization data is not a map!");
        }
    }

    @Override
    protected void check(SpreadSheet data, MessageCollection errors) {
        super.check(data, errors);
        if (this.m_PanelOutput.getWriter() == null) {
            errors.add("No output writer available - no file selected?");
        }
        if (((File)this.m_PanelOutput.getCurrent()).isDirectory()) {
            errors.add("Output points to a directory!");
        }
    }

    @Override
    protected void doProcess(SpreadSheet data, MessageCollection errors) {
        File output;
        SpreadSheetWriter writer = this.m_PanelOutput.getWriter();
        if (!writer.write(data, output = (File)this.m_PanelOutput.getCurrent())) {
            errors.add("Failed to write data to: " + output);
        } else {
            this.notifyOwner(SpreadSheetProcessorEvent.EventType.DATA_IS_OUTPUT, "Data saved to: " + output);
        }
    }
}

