/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.tools.SpreadSheetViewerPanel;
import adams.gui.tools.spreadsheetviewer.AbstractViewPlugin;
import adams.gui.tools.spreadsheetviewer.SpreadSheetPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractSelectedSheetsViewPlugin
extends AbstractViewPlugin {
    private static final long serialVersionUID = 7647402907873370803L;
    protected SpreadSheetPanel[] m_SelectedPanels;

    protected SpreadSheetPanel[] getAllPanels() {
        ArrayList<SpreadSheetPanel> result = new ArrayList<SpreadSheetPanel>();
        SpreadSheetViewerPanel owner = (SpreadSheetViewerPanel)((Object)GUIHelper.getParent((Container)((Object)this.m_CurrentPanel), SpreadSheetViewerPanel.class));
        if (owner != null) {
            result.addAll(Arrays.asList(owner.getAllPanels()));
        }
        return result.toArray(new SpreadSheetPanel[result.size()]);
    }

    protected JPanel createListPanel(ApprovalDialog dialog) {
        JPanel result = new JPanel(new BorderLayout());
        final SpreadSheetPanel[] panels = this.getAllPanels();
        DefaultListModel<CallSite> model = new DefaultListModel<CallSite>();
        int index = -1;
        for (SpreadSheetPanel p : panels) {
            if (p == this.m_CurrentPanel) {
                index = model.getSize();
            }
            model.addElement((CallSite)((Object)(model.getSize() + 1 + ": " + p.getTabTitle())));
        }
        final JList list = new JList(model);
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] indices = list.getSelectedIndices();
                AbstractSelectedSheetsViewPlugin.this.m_SelectedPanels = new SpreadSheetPanel[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    AbstractSelectedSheetsViewPlugin.this.m_SelectedPanels[i] = panels[indices[i]];
                }
            }
        });
        list.setSelectedIndex(index);
        BaseScrollPane scrollPane = new BaseScrollPane(list);
        scrollPane.setPreferredSize(new Dimension(200, 1));
        result.add((Component)scrollPane, "Center");
        return result;
    }

    protected abstract JPanel createConfigurationPanel(ApprovalDialog var1);

    protected Dimension getDialogSize() {
        return GUIHelper.getDefaultSmallDialogDimension();
    }

    protected boolean hasApprovalButton() {
        return true;
    }

    protected boolean hasCancelButton() {
        return true;
    }

    protected ApprovalDialog createDialog() {
        ApprovalDialog result = this.m_CurrentPanel.getParentDialog() != null ? new ApprovalDialog(this.m_CurrentPanel.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(this.m_CurrentPanel.getParentFrame(), true);
        result.setTitle(this.getMenuText());
        result.setApproveVisible(this.hasApprovalButton());
        result.setCancelVisible(this.hasCancelButton());
        result.setDiscardVisible(false);
        result.setSize(this.getDialogSize());
        JPanel panel = new JPanel(new BorderLayout());
        result.getContentPane().add((Component)panel, "Center");
        JPanel panelList = this.createListPanel(result);
        JPanel panelConfig = this.createConfigurationPanel(result);
        if (panelConfig == null) {
            panel.add((Component)panelList, "Center");
        } else {
            panel.add((Component)panelList, "West");
            panel.add((Component)panelConfig, "Center");
        }
        return result;
    }

    protected abstract BasePanel process();

    @Override
    protected BasePanel doGenerate(SpreadSheet sheet) {
        BasePanel result = null;
        ApprovalDialog dialog = this.createDialog();
        if (dialog != null) {
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            if (dialog.getOption() == 0) {
                result = this.process();
            } else if (dialog.getOption() == 2) {
                this.m_CanceledByUser = true;
            }
        }
        return result;
    }
}

