/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.MultiPagePane;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.spreadsheettable.CellRenderingCustomizer;
import adams.gui.core.spreadsheettable.DefaultCellRenderingCustomizer;
import adams.gui.tools.SpreadSheetViewerPanel;
import adams.gui.tools.spreadsheetviewer.SpreadSheetPanel;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;

public class MultiPagePane
extends adams.gui.core.MultiPagePane {
    private static final long serialVersionUID = -2048229771213837710L;
    public static final String PREFIX_TITLE = "new";
    public static final String PREFIX_MODIFIED = "*";
    protected SpreadSheetViewerPanel m_Owner;
    protected int m_NumDecimals;
    protected CellRenderingCustomizer m_CellRenderingCustomizer;

    public MultiPagePane(SpreadSheetViewerPanel owner) {
        this.setOwner(owner);
        this.addChangeListener(e -> this.pageSelected(e));
        this.setMaxPageCloseUndo(10);
        this.setPageCloseApprover((source, index) -> {
            SpreadSheetPanel panel = this.getPanelAt(index);
            boolean result = this.checkForModified(panel);
            if (result && panel.isModified()) {
                panel.setModified(false);
                this.updatePage(index);
            }
            return result;
        });
    }

    protected void initialize() {
        super.initialize();
        this.m_NumDecimals = -1;
        this.m_CellRenderingCustomizer = new DefaultCellRenderingCustomizer();
    }

    public void setOwner(SpreadSheetViewerPanel value) {
        this.m_Owner = value;
    }

    public SpreadSheetViewerPanel getOwner() {
        return this.m_Owner;
    }

    public int getPanelCount() {
        return this.getPageCount();
    }

    public SpreadSheetPanel[] getAllPanels() {
        SpreadSheetPanel[] result = new SpreadSheetPanel[this.getPageCount()];
        for (int i = 0; i < this.getPageCount(); ++i) {
            result[i] = this.getPanelAt(i);
        }
        return result;
    }

    public SpreadSheetPanel getPanelAt(int index) {
        if (index < 0 || index >= this.getPageCount()) {
            return null;
        }
        SpreadSheetPanel result = (SpreadSheetPanel)((Object)this.getPageAt(index));
        return result;
    }

    public SpreadSheetTable getTableAt(int index) {
        SpreadSheetTable result = null;
        SpreadSheetPanel panel = this.getPanelAt(index);
        if (panel != null) {
            result = panel.getTable();
        }
        return result;
    }

    public SpreadSheet getSheetAt(int index) {
        SpreadSheet result = null;
        SpreadSheetTable table = this.getTableAt(index);
        if (table == null) {
            return result;
        }
        result = table.toSpreadSheet();
        return result;
    }

    public void setNumDecimalsAt(int index, int numDec) {
        this.getTableAt(index).setNumDecimals(numDec);
    }

    public int getNumDecimalsAt(int index) {
        return this.getTableAt(index).getNumDecimals();
    }

    public void setNumDecimals(int numDec) {
        this.m_NumDecimals = numDec;
        for (int i = 0; i < this.getPageCount(); ++i) {
            this.setNumDecimalsAt(i, numDec);
        }
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public void setCellRenderingCustomizerAt(int index, CellRenderingCustomizer cust) {
        this.getTableAt(index).setCellRenderingCustomizer(cust);
    }

    public CellRenderingCustomizer getCellRenderingCustomizerAt(int index) {
        return this.getTableAt(index).getCellRenderingCustomizer();
    }

    public void setCellRenderingCustomizer(CellRenderingCustomizer cust) {
        this.m_CellRenderingCustomizer = cust;
        for (int i = 0; i < this.getPageCount(); ++i) {
            this.setCellRenderingCustomizerAt(i, cust);
        }
    }

    public CellRenderingCustomizer getCellRenderingCustomizer() {
        return this.m_CellRenderingCustomizer;
    }

    public void setShowFormulasAt(int index, boolean value) {
        this.getTableAt(index).setShowFormulas(value);
    }

    public boolean getShowFormulas(int index) {
        return this.getTableAt(index).getShowFormulas();
    }

    public void setShowFormulas(boolean value) {
        for (int i = 0; i < this.getPageCount(); ++i) {
            this.setShowFormulasAt(i, value);
        }
    }

    public void setShowCellTypesAt(int index, boolean value) {
        this.getTableAt(index).setShowCellTypes(value);
    }

    public boolean getShowCellTypes(int index) {
        return this.getTableAt(index).getShowCellTypes();
    }

    public void setShowCellTypes(boolean value) {
        for (int i = 0; i < this.getPageCount(); ++i) {
            this.setShowCellTypesAt(i, value);
        }
    }

    public void setReadOnlyAt(int index, boolean value) {
        this.getTableAt(index).setReadOnly(value);
    }

    public boolean getReadOnlyAt(int index) {
        return this.getTableAt(index).isReadOnly();
    }

    public void setReadOnly(boolean value) {
        for (int i = 0; i < this.getPageCount(); ++i) {
            this.setReadOnlyAt(i, value);
        }
    }

    public void setModifiedAt(int index, boolean value) {
        this.getTableAt(index).setModified(value);
    }

    public boolean isModifiedAt(int index) {
        return this.getTableAt(index).isModified();
    }

    public void setModified(boolean value) {
        for (int i = 0; i < this.getPageCount(); ++i) {
            this.setModifiedAt(i, value);
        }
    }

    protected boolean checkForModified() {
        if (this.m_Owner == null) {
            return true;
        }
        return this.m_Owner.checkForModified();
    }

    protected boolean checkForModified(SpreadSheetPanel panel) {
        if (this.m_Owner == null) {
            return true;
        }
        return this.m_Owner.checkForModified(panel);
    }

    public SpreadSheetPanel getCurrentPanel() {
        return this.getPanelAt(this.getSelectedIndex());
    }

    public SpreadSheetTable getCurrentTable() {
        return this.getTableAt(this.getSelectedIndex());
    }

    public SpreadSheet getCurrentSheet() {
        return this.getSheetAt(this.getSelectedIndex());
    }

    public SpreadSheetPanel addPage(File file, SpreadSheet sheet) {
        SpreadSheetPanel result = this.addPage(this.createPageTitle(file, sheet), sheet);
        result.setFilename(file);
        return result;
    }

    public SpreadSheetPanel addPage(String title, SpreadSheet sheet) {
        SpreadSheetPanel result = new SpreadSheetPanel(this);
        result.setNumDecimals(this.m_NumDecimals);
        result.setCellRenderingCustomizer(this.m_CellRenderingCustomizer);
        result.setSheet(sheet);
        result.setReadOnly(false);
        this.addPage(title, (Component)((Object)result));
        this.setSelectedIndex(this.getPageCount() - 1);
        return result;
    }

    public String createPageTitle(File file, SpreadSheet sheet) {
        return file.getName() + (String)(sheet.getName() != null ? "/" + sheet.getName() : "");
    }

    public List<String> getPageTitles() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.getPageCount(); ++i) {
            result.add(this.getTitleAt(i));
        }
        return result;
    }

    public String newTitle() {
        String result;
        HashSet<String> titles = new HashSet<String>(this.getPageTitles());
        int i = 0;
        while (titles.contains(result = PREFIX_TITLE + ++i)) {
        }
        return result;
    }

    protected void pageSelected(ChangeEvent e) {
        if (this.getPanelCount() == 0 || this.getSelectedIndex() == -1) {
            this.m_Owner.getViewerTabs().notifyTabs(null);
        } else {
            this.m_Owner.getViewerTabs().notifyTabs(this.m_Owner.getCurrentPanel());
        }
        this.m_Owner.updateMenu();
        this.m_Owner.updateActions();
    }

    public MultiPagePane.PageContainer removePageAt(int index) {
        if (index < 0) {
            return null;
        }
        if (!this.checkForModified(this.getPanelAt(index))) {
            return null;
        }
        SpreadSheetPanel panel = this.getPanelAt(index);
        panel.cleanUp();
        return super.removePageAt(index);
    }

    public void updateCurrentPage() {
        this.updatePage(this.getSelectedIndex());
    }

    public void updatePage(int index) {
        if (this.getPanelAt(index) == null) {
            return;
        }
        Object title = this.getTitleAt(index);
        if (this.isModifiedAt(index)) {
            if (!((String)title).startsWith(PREFIX_MODIFIED)) {
                title = PREFIX_MODIFIED + (String)title;
            }
        } else if (((String)title).startsWith(PREFIX_MODIFIED)) {
            title = ((String)title).substring(PREFIX_MODIFIED.length());
        }
        this.setTitleAt(index, (String)title);
    }
}

