/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BasePanel;
import adams.gui.core.ImageManager;
import adams.gui.event.SortSetupEvent;
import adams.gui.tools.spreadsheetviewer.SortPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;

public class SortDefinitionPanel
extends BasePanel {
    private static final long serialVersionUID = 8473224107052394069L;
    protected SortPanel m_Owner;
    protected BaseComboBox m_ComboBoxNames;
    protected BaseComboBox m_ComboBoxSorting;
    protected BaseButton m_ButtonMoveUp;
    protected BaseButton m_ButtonMoveDown;
    protected BaseButton m_ButtonRemove;

    public SortDefinitionPanel(SortPanel owner) {
        this.m_Owner = owner;
        this.update();
        this.updateButtons();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new FlowLayout(0));
        this.m_ComboBoxNames = new BaseComboBox();
        this.m_ComboBoxNames.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDefinitionPanel.this.setupModified();
            }
        });
        JLabel label = new JLabel("Names");
        label.setDisplayedMnemonic('N');
        label.setLabelFor((Component)this.m_ComboBoxNames);
        this.add(label);
        this.add((Component)this.m_ComboBoxNames);
        this.m_ComboBoxSorting = new BaseComboBox((Object[])new String[]{"Ascending", "Descending"});
        this.m_ComboBoxSorting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDefinitionPanel.this.setupModified();
            }
        });
        label = new JLabel("Sorting");
        label.setDisplayedMnemonic('S');
        label.setLabelFor((Component)this.m_ComboBoxNames);
        this.add(label);
        this.add((Component)this.m_ComboBoxSorting);
        this.m_ButtonMoveUp = new BaseButton((Icon)ImageManager.getIcon((String)"arrow_up.gif"));
        this.m_ButtonMoveUp.setToolTipText("Click to move condition up");
        this.m_ButtonMoveUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDefinitionPanel.this.moveDefinition(true);
            }
        });
        this.add((Component)this.m_ButtonMoveUp);
        this.m_ButtonMoveDown = new BaseButton((Icon)ImageManager.getIcon((String)"arrow_down.gif"));
        this.m_ButtonMoveDown.setToolTipText("Click to move condition down");
        this.m_ButtonMoveDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDefinitionPanel.this.moveDefinition(false);
            }
        });
        this.add((Component)this.m_ButtonMoveDown);
        this.m_ButtonRemove = new BaseButton((Icon)ImageManager.getIcon((String)"delete.gif"));
        this.m_ButtonRemove.setToolTipText("Click to remove condition");
        this.m_ButtonRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SortDefinitionPanel.this.removeDefinition();
            }
        });
        this.add((Component)this.m_ButtonRemove);
    }

    public SortPanel getOwner() {
        return this.m_Owner;
    }

    public String getColumnName() {
        if (this.m_ComboBoxNames.getSelectedIndex() == -1) {
            return null;
        }
        return (String)this.m_ComboBoxNames.getSelectedItem();
    }

    public boolean isAscending() {
        return this.m_ComboBoxSorting.getSelectedIndex() == 0;
    }

    protected void moveDefinition(boolean up) {
        this.getOwner().moveDefinition(this, up);
    }

    protected void removeDefinition() {
        this.getOwner().removeDefinition(this);
    }

    public void update() {
        List<String> names = this.getOwner().getColumnNames();
        this.m_ComboBoxNames.setModel(new DefaultComboBoxModel<Object>(names.toArray()));
        if (names.size() > 0) {
            this.m_ComboBoxNames.setSelectedIndex(0);
        }
        this.m_ComboBoxSorting.setSelectedIndex(0);
    }

    public void updateButtons() {
        this.m_ButtonMoveUp.setEnabled(!this.getOwner().isFirstDefinition(this));
        this.m_ButtonMoveDown.setEnabled(!this.getOwner().isLastDefinition(this));
    }

    protected void setupModified() {
        this.getOwner().notifySortSetupListeners(new SortSetupEvent(this.m_Owner, this, SortSetupEvent.EventType.MODIFIED));
    }

    public String toString() {
        return ((Object)((Object)this)).hashCode() + ", colname=" + this.getColumnName() + ", asc=" + this.isAscending();
    }
}

