/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.chart;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.sink.SequencePlotter;
import adams.flow.sink.sequenceplotter.MouseClickAction;
import adams.flow.sink.sequenceplotter.ViewDataClickAction;
import adams.flow.transformer.SpreadSheetPlotGenerator;
import adams.gui.tools.spreadsheetviewer.chart.AbstractXYChartGenerator;
import adams.gui.visualization.core.plot.HitDetectorSupporter;
import adams.gui.visualization.sequence.AbstractXYSequencePointHitDetector;
import adams.gui.visualization.sequence.CirclePaintlet;
import adams.gui.visualization.sequence.CrossPaintlet;
import adams.gui.visualization.sequence.NullPaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;

public class ScatterPlot
extends AbstractXYChartGenerator {
    private static final long serialVersionUID = -2088311829009151566L;
    protected PlotType m_PlotType;
    protected int m_Diameter;
    protected XYSequencePaintlet m_OverlayPaintlet;

    public String globalInfo() {
        return "Generates a scatter plot by plotting the X column against one or more Y columns.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("plot-type", "plotType", (Object)PlotType.CIRCLE);
        this.m_OptionManager.add("diameter", "diameter", (Object)7, (Number)1, null);
        this.m_OptionManager.add("overlay-paintlet", "overlayPaintlet", (Object)new NullPaintlet());
    }

    @Override
    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"plotType", (Object)((Object)this.m_PlotType), (String)", type: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"diameter", (Object)this.m_Diameter, (String)", diameter: ");
        return result;
    }

    public void setPlotType(PlotType value) {
        this.m_PlotType = value;
        this.reset();
    }

    public PlotType getPlotType() {
        return this.m_PlotType;
    }

    public String plotTypeTipText() {
        return "The plot type to use.";
    }

    public void setDiameter(int value) {
        if (this.getOptionManager().isValid("diameter", (Number)value)) {
            this.m_Diameter = value;
            this.reset();
        }
    }

    public int getDiameter() {
        return this.m_Diameter;
    }

    public String diameterTipText() {
        return "The diameter of the circle/cross in pixels (if no error data supplied).";
    }

    public void setOverlayPaintlet(XYSequencePaintlet value) {
        this.m_OverlayPaintlet = value;
        this.reset();
    }

    public XYSequencePaintlet getOverlayPaintlet() {
        return this.m_OverlayPaintlet;
    }

    public String overlayPaintletTipText() {
        return "The paintlet to use for painting the overlay data (if any).";
    }

    @Override
    protected void addChartGeneration(Flow flow, String name, SpreadSheet sheet) {
        CirclePaintlet paintlet;
        super.addChartGeneration(flow, name, sheet);
        SpreadSheetPlotGenerator pg = this.configureGenerator(sheet);
        flow.add((Actor)pg);
        SequencePlotter plotter = new SequencePlotter();
        if (name != null) {
            plotter.setName(name);
        } else {
            plotter.setName("Scatter plot");
        }
        plotter.setTitle(plotter.getName());
        this.configureSequencePlotter(sheet, plotter);
        plotter.setOverlayPaintlet((XYSequencePaintlet)this.m_OverlayPaintlet.shallowCopy());
        switch (this.m_PlotType) {
            case CIRCLE: {
                paintlet = new CirclePaintlet();
                paintlet.setDiameter(this.m_Diameter);
                break;
            }
            case CROSS: {
                paintlet = new CrossPaintlet();
                ((CrossPaintlet)paintlet).setDiameter(this.m_Diameter);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled plot type: " + this.m_PlotType);
            }
        }
        plotter.setPaintlet((XYSequencePaintlet)paintlet);
        if (((HitDetectorSupporter)paintlet).getHitDetector() instanceof AbstractXYSequencePointHitDetector) {
            ViewDataClickAction action = new ViewDataClickAction();
            action.setHitDetector((AbstractXYSequencePointHitDetector)((HitDetectorSupporter)paintlet).getHitDetector());
            plotter.setMouseClickAction((MouseClickAction)action);
        }
        flow.add((Actor)plotter);
    }

    public static enum PlotType {
        CIRCLE,
        CROSS;

    }
}

