/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.menu;

import adams.core.logging.LoggingHelper;
import adams.gui.core.GUIHelper;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.tools.spreadsheetviewer.SpreadSheetPanel;
import adams.gui.tools.spreadsheetviewer.chart.AbstractChartGenerator;
import adams.gui.tools.spreadsheetviewer.chart.ScatterPlot;
import adams.gui.tools.spreadsheetviewer.menu.AbstractSpreadSheetViewerMenuItemAction;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;

public class DataChart
extends AbstractSpreadSheetViewerMenuItemAction {
    private static final long serialVersionUID = 5235570137451285010L;
    protected AbstractChartGenerator m_LastChart;

    protected String getTitle() {
        return "Chart...";
    }

    protected GenericObjectEditorDialog createDialog() {
        GenericObjectEditorDialog result = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
        result.setTitle("Chart");
        result.setUISettingsPrefix(AbstractChartGenerator.class);
        result.getGOEEditor().setClassType(AbstractChartGenerator.class);
        result.getGOEEditor().setCanChangeClassInDialog(true);
        result.setCurrent((Object)this.m_LastChart);
        result.setLocationRelativeTo((Component)this.m_State);
        return result;
    }

    protected void doActionPerformed(ActionEvent e) {
        SpreadSheetPanel panel = this.getTabbedPane().getCurrentPanel();
        if (panel == null) {
            return;
        }
        if (this.m_LastChart == null) {
            this.m_LastChart = new ScatterPlot();
        }
        ((GenericObjectEditorDialog)this.getDialog()).setVisible(true);
        if (((GenericObjectEditorDialog)this.getDialog()).getResult() != 0) {
            return;
        }
        AbstractChartGenerator generator = (AbstractChartGenerator)((Object)((GenericObjectEditorDialog)this.getDialog()).getGOEEditor().getValue());
        try {
            panel.generateChart(generator);
        }
        catch (Exception ex) {
            String msg = "Failed to generate chart:\n" + LoggingHelper.throwableToString((Throwable)ex);
            if (this.getParentDialog() != null) {
                GUIHelper.showErrorMessage((Component)this.getParentDialog(), (String)msg);
            }
            GUIHelper.showErrorMessage((Component)this.getParentFrame(), (String)msg);
        }
    }

    protected void doUpdate() {
        this.setEnabled(this.isSheetSelected());
    }
}

