/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer.tab;

import adams.data.spreadsheet.SpreadSheet;
import adams.db.SQLStatement;
import adams.flow.core.Token;
import adams.gui.core.BaseButton;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.core.RecentSQLStatementsHandler;
import adams.gui.core.SpreadSheetQueryEditorPanel;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.help.HelpFrame;
import adams.gui.tools.spreadsheetviewer.MultiPagePane;
import adams.gui.tools.spreadsheetviewer.tab.AbstractViewerTab;
import adams.parser.SpreadSheetQuery;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Query
extends AbstractViewerTab {
    private static final long serialVersionUID = -4215008790991120558L;
    public static final String SESSION_FILE = "SpreadsSheetViewerQueries.props";
    protected SpreadSheetQueryEditorPanel m_PanelQuery;
    protected BaseButton m_ButtonHelp;
    protected BaseButton m_ButtonHistory;
    protected BaseButton m_ButtonExecute;
    protected JPopupMenu m_PopupMenu;
    protected RecentSQLStatementsHandler<JPopupMenu> m_RecentStatementsHandler;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelQuery = new SpreadSheetQueryEditorPanel();
        this.m_PanelQuery.setWordWrap(true);
        this.m_PanelQuery.getTextPane().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            protected void update() {
                Query.this.m_ButtonExecute.setEnabled(Query.this.getCurrentPanel() != null && !Query.this.m_PanelQuery.getQuery().isEmpty());
            }
        });
        this.add((Component)((Object)this.m_PanelQuery), "Center");
        JPanel panelButtons = new JPanel(new BorderLayout());
        this.add(panelButtons, "South");
        JPanel panelButtonsLeft = new JPanel(new FlowLayout(0));
        panelButtons.add((Component)panelButtonsLeft, "West");
        JPanel panelButtonsRight = new JPanel(new FlowLayout(2));
        panelButtons.add((Component)panelButtonsRight, "East");
        this.m_ButtonHelp = new BaseButton((Icon)ImageManager.getIcon((String)"help.gif"));
        this.m_ButtonHelp.setMnemonic('H');
        this.m_ButtonHelp.addActionListener(e -> this.showHelp());
        panelButtonsLeft.add((Component)this.m_ButtonHelp);
        this.m_ButtonHistory = new BaseButton((Icon)ImageManager.getIcon((String)"history.png"));
        this.m_ButtonHistory.setToolTipText("Recent queries");
        this.m_ButtonHistory.addActionListener(e -> this.m_PopupMenu.show((Component)this.m_ButtonHistory, 0, this.m_ButtonHistory.getHeight()));
        panelButtonsRight.add((Component)this.m_ButtonHistory);
        this.m_ButtonExecute = new BaseButton((Icon)ImageManager.getIcon((String)"run.gif"));
        this.m_ButtonExecute.setMnemonic('E');
        this.m_ButtonExecute.setEnabled(false);
        this.m_ButtonExecute.addActionListener(e -> this.performQuery());
        panelButtonsRight.add((Component)this.m_ButtonExecute);
        this.m_PopupMenu = new JPopupMenu();
        this.m_RecentStatementsHandler = new RecentSQLStatementsHandler(SESSION_FILE, 10, (Object)this.m_PopupMenu);
        this.m_RecentStatementsHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JPopupMenu, SQLStatement>(){

            public void recentItemAdded(RecentItemEvent<JPopupMenu, SQLStatement> e) {
            }

            public void recentItemSelected(RecentItemEvent<JPopupMenu, SQLStatement> e) {
                Query.this.setStatement((SQLStatement)e.getItem());
            }
        });
    }

    @Override
    public String getTitle() {
        return "Query";
    }

    protected void performQuery() {
        SpreadSheet sheet = this.getCurrentPanel().getSheet();
        adams.flow.transformer.SpreadSheetQuery query = new adams.flow.transformer.SpreadSheetQuery();
        query.setQuery(this.m_PanelQuery.getQuery());
        String msg = query.setUp();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)msg);
            query.cleanUp();
            return;
        }
        query.input(new Token((Object)sheet));
        msg = query.execute();
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)msg);
            query.cleanUp();
            return;
        }
        this.m_RecentStatementsHandler.addRecentItem((Object)new SQLStatement(this.m_PanelQuery.getContent()));
        Token output = null;
        if (query.hasPendingOutput()) {
            output = query.output();
        }
        if (output != null) {
            sheet = (SpreadSheet)output.getPayload();
            MultiPagePane tabbedPane = this.getOwner().getOwner().getMultiPagePane();
            tabbedPane.addPage(tabbedPane.newTitle(), sheet);
        }
        query.cleanUp();
    }

    protected void showHelp() {
        HelpFrame.showHelp(SpreadSheetQuery.class);
    }

    public void setStatement(SQLStatement value) {
        this.m_PanelQuery.setContent(value.getValue());
    }
}

