/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.sqlworkbench;

import adams.core.MessageCollection;
import adams.core.logging.LoggingHelper;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.sql.AbstractTypeMapper;
import adams.data.spreadsheet.sql.DefaultTypeMapper;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnectionProvider;
import adams.db.MetaDataType;
import adams.db.MetaDataUtils;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseComboBox;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTable;
import adams.gui.core.BaseTextArea;
import adams.gui.core.BaseTextField;
import adams.gui.core.Fonts;
import adams.gui.core.ImageManager;
import adams.gui.core.ParameterPanel;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.core.SqlConnectionPanel;
import adams.gui.goe.GenericObjectEditorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.table.TableModel;

public class SqlMetaDataPanel
extends BasePanel
implements DatabaseConnectionProvider {
    private static final long serialVersionUID = -7292928176878371096L;
    protected SqlConnectionPanel m_PanelConnection;
    protected JPanel m_PanelTable;
    protected SpreadSheetTable m_TableResults;
    protected SearchPanel m_PanelTableSearch;
    protected JPanel m_PanelText;
    protected BaseTextArea m_TextResults;
    protected JPanel m_PanelNoResult;
    protected JPanel m_PanelTop;
    protected JPanel m_PanelCenter;
    protected ParameterPanel m_PanelParameters;
    protected BaseComboBox<MetaDataType> m_ComboBoxMetaDataType;
    protected GenericObjectEditorPanel m_PanelMapper;
    protected BaseTextField m_TextTable;
    protected BaseButton m_ButtonExecute;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelTop = new JPanel(new BorderLayout());
        this.add(this.m_PanelTop, "North");
        this.m_PanelCenter = new JPanel(new BorderLayout());
        this.add(this.m_PanelCenter, "Center");
        this.m_PanelConnection = new SqlConnectionPanel();
        this.m_PanelConnection.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_PanelTop.add((Component)this.m_PanelConnection, "North");
        this.m_PanelParameters = new ParameterPanel();
        this.m_PanelTop.add((Component)this.m_PanelParameters, "Center");
        this.m_ComboBoxMetaDataType = new BaseComboBox((Object[])MetaDataType.values());
        this.m_PanelParameters.addParameter("Meta-data", this.m_ComboBoxMetaDataType);
        this.m_PanelMapper = new GenericObjectEditorPanel(AbstractTypeMapper.class, (Object)new DefaultTypeMapper());
        this.m_PanelParameters.addParameter("Type mapper", (Component)this.m_PanelMapper);
        this.m_TextTable = new BaseTextField(20);
        this.m_PanelParameters.addParameter("Table", (Component)this.m_TextTable);
        JPanel panelButtons = new JPanel(new FlowLayout(0));
        this.m_PanelTop.add((Component)panelButtons, "South");
        this.m_ButtonExecute = new BaseButton((Icon)ImageManager.getIcon((String)"run.gif"));
        this.m_ButtonExecute.addActionListener(e -> this.execute());
        this.m_ButtonExecute.setToolTipText("Executes the query (Alt+X)");
        panelButtons.add((Component)this.m_ButtonExecute);
        this.m_PanelNoResult = new JPanel();
        this.m_PanelCenter.add((Component)this.m_PanelNoResult, "Center");
        this.m_TableResults = new SpreadSheetTable(new SpreadSheetTableModel());
        this.m_TableResults.setShowSimpleCellPopupMenu(true);
        this.m_TableResults.setShowSimpleHeaderPopupMenu(true);
        this.m_TableResults.setColumnWidthApproach(BaseTable.ColumnWidthApproach.NONE);
        this.m_PanelTable = new JPanel(new BorderLayout());
        this.m_PanelTable.add((Component)new BaseScrollPane((Component)this.m_TableResults), "Center");
        this.m_PanelTableSearch = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, false);
        this.m_PanelTableSearch.addSearchListener(e -> this.m_TableResults.search(e.getParameters().getSearchString(), e.getParameters().isRegExp()));
        this.m_PanelTable.add((Component)this.m_PanelTableSearch, "South");
        this.m_TextResults = new BaseTextArea(5, 40);
        this.m_TextResults.setTextFont(Fonts.getMonospacedFont());
        this.m_PanelText = new JPanel(new BorderLayout());
        this.m_PanelText.add((Component)new BaseScrollPane((Component)this.m_TextResults), "Center");
    }

    protected void finishInit() {
        super.finishInit();
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_ButtonExecute.setEnabled(this.m_ComboBoxMetaDataType.getSelectedIndex() > -1);
    }

    public void execute() {
        SwingWorker worker = new SwingWorker(){
            protected SpreadSheet m_Sheet = null;
            protected String m_Error = null;
            protected String m_Result = null;

            protected Object doInBackground() throws Exception {
                SqlMetaDataPanel.this.m_ButtonExecute.setEnabled(false);
                SqlMetaDataPanel.this.m_PanelParameters.setEnabled(false);
                SqlMetaDataPanel.this.m_PanelConnection.setEnabled(false);
                MessageCollection errors = new MessageCollection();
                try {
                    this.m_Sheet = MetaDataUtils.getMetaData(SqlMetaDataPanel.this.m_PanelConnection.getDatabaseConnection(), (AbstractTypeMapper)((Object)SqlMetaDataPanel.this.m_PanelMapper.getCurrent()), (MetaDataType)((Object)SqlMetaDataPanel.this.m_ComboBoxMetaDataType.getSelectedItem()), SqlMetaDataPanel.this.m_TextTable.getText(), errors);
                    if (!errors.isEmpty()) {
                        this.m_Error = errors.toString();
                    } else {
                        this.m_Result = "Meta-data query succeeded!";
                    }
                }
                catch (Exception e) {
                    this.m_Error = "Failed to execute meta-data query for:\n\n" + SqlMetaDataPanel.this.m_ComboBoxMetaDataType.getSelectedItem() + "\n\nException:\n\n" + LoggingHelper.throwableToString((Throwable)e);
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                SqlMetaDataPanel.this.m_PanelParameters.setEnabled(true);
                SqlMetaDataPanel.this.m_ButtonExecute.setEnabled(true);
                SqlMetaDataPanel.this.m_PanelConnection.setEnabled(true);
                SqlMetaDataPanel.this.m_PanelCenter.removeAll();
                if (this.m_Error != null) {
                    SqlMetaDataPanel.this.m_TextResults.setText(this.m_Error);
                    SqlMetaDataPanel.this.m_PanelCenter.add((Component)SqlMetaDataPanel.this.m_PanelText, "Center");
                } else if (this.m_Sheet != null) {
                    SqlMetaDataPanel.this.m_TableResults.setModel((TableModel)new SpreadSheetTableModel(this.m_Sheet));
                    SqlMetaDataPanel.this.m_TableResults.setOptimalColumnWidthBounded(150);
                    SqlMetaDataPanel.this.m_PanelCenter.add((Component)SqlMetaDataPanel.this.m_PanelTable, "Center");
                } else {
                    SqlMetaDataPanel.this.m_TextResults.setText(this.m_Result);
                    SqlMetaDataPanel.this.m_PanelCenter.add((Component)SqlMetaDataPanel.this.m_PanelText, "Center");
                }
                SqlMetaDataPanel.this.m_PanelCenter.invalidate();
                SqlMetaDataPanel.this.m_PanelCenter.revalidate();
                SqlMetaDataPanel.this.m_PanelCenter.repaint();
            }
        };
        worker.execute();
    }

    public AbstractDatabaseConnection getDatabaseConnection() {
        return this.m_PanelConnection.getDatabaseConnection();
    }
}

