/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectrenderer;

import adams.core.MessageCollection;
import adams.data.conversion.ContainerToSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.AbstractContainer;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.visualization.debug.objectrenderer.AbstractObjectRenderer;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.table.TableModel;
import nz.ac.waikato.cms.locator.ClassLocator;

public class FlowContainerRenderer
extends AbstractObjectRenderer {
    private static final long serialVersionUID = -3528006886476495175L;
    protected SpreadSheetTable m_LastTable;

    public boolean handles(Class cls) {
        return ClassLocator.isSubclass(AbstractContainer.class, (Class)cls);
    }

    public boolean canRenderCached(Object obj, JPanel panel) {
        return this.m_LastTable != null;
    }

    protected SpreadSheet containerToSheet(AbstractContainer cont, MessageCollection errors) {
        SpreadSheet result = null;
        ContainerToSpreadSheet conv = new ContainerToSpreadSheet();
        conv.setInput(cont);
        String msg = conv.convert();
        if (msg == null) {
            result = (SpreadSheet)conv.getOutput();
        } else {
            errors.add(msg);
        }
        conv.cleanUp();
        return result;
    }

    protected String doRenderCached(Object obj, JPanel panel, Integer limit) {
        String result = null;
        AbstractContainer cont = (AbstractContainer)obj;
        MessageCollection errors = new MessageCollection();
        SpreadSheet sheet = this.containerToSheet(cont, errors);
        if (errors.isEmpty() && sheet != null) {
            this.m_LastTable.setModel((TableModel)new SpreadSheetTableModel(sheet));
            BaseScrollPane scrollPane = new BaseScrollPane((Component)this.m_LastTable);
            panel.add((Component)scrollPane, "Center");
        } else {
            result = errors.isEmpty() ? "Failed to convert container!" : errors.toString();
        }
        return result;
    }

    protected String doRender(Object obj, JPanel panel, Integer limit) {
        String result = null;
        AbstractContainer cont = (AbstractContainer)obj;
        MessageCollection errors = new MessageCollection();
        SpreadSheet sheet = this.containerToSheet(cont, errors);
        if (errors.isEmpty() && sheet != null) {
            SpreadSheetTable table = new SpreadSheetTable(sheet);
            BaseScrollPane scrollPane = new BaseScrollPane((Component)table);
            panel.add((Component)scrollPane, "Center");
            this.m_LastTable = table;
        } else {
            result = errors.isEmpty() ? "Failed to convert container!" : errors.toString();
        }
        return result;
    }
}

