/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectrenderer;

import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.dialog.SpreadSheetPanel;
import adams.gui.visualization.debug.objectrenderer.AbstractObjectRenderer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.JPanel;
import nz.ac.waikato.cms.locator.ClassLocator;

public class SetRenderer
extends AbstractObjectRenderer {
    private static final long serialVersionUID = -3528006886476495175L;
    protected SpreadSheetPanel m_LastSheetPanel;

    public boolean handles(Class cls) {
        return ClassLocator.hasInterface(Set.class, (Class)cls);
    }

    public boolean canRenderCached(Object obj, JPanel panel) {
        return this.m_LastSheetPanel != null;
    }

    protected SpreadSheet setToSheet(Set set) {
        DefaultSpreadSheet result = new DefaultSpreadSheet();
        HeaderRow row = result.getHeaderRow();
        row.addCell("V").setContentAsString("Value");
        ArrayList valuesObj = new ArrayList(set);
        boolean allComp = true;
        for (Object key : valuesObj) {
            if (key instanceof Comparable) continue;
            allComp = false;
            break;
        }
        if (allComp) {
            ArrayList<Comparable> valuesComp = new ArrayList<Comparable>();
            for (Object key : valuesObj) {
                valuesComp.add((Comparable)key);
            }
            Collections.sort(valuesComp);
            valuesObj = valuesComp;
        }
        for (Object value : valuesObj) {
            row = result.addRow();
            row.addCell("V").setNative(value);
        }
        return result;
    }

    protected String doRenderCached(Object obj, JPanel panel, Integer limit) {
        this.m_LastSheetPanel.setSpreadSheet(this.setToSheet((Set)obj));
        panel.add((Component)this.m_LastSheetPanel, "Center");
        return null;
    }

    protected String doRender(Object obj, JPanel panel, Integer limit) {
        SpreadSheet sheet = this.setToSheet((Set)obj);
        SpreadSheetPanel sheetPanel = new SpreadSheetPanel();
        sheetPanel.setSpreadSheet(sheet);
        sheetPanel.setShowSearch(true);
        panel.add((Component)sheetPanel, "Center");
        this.m_LastSheetPanel = sheetPanel;
        return null;
    }
}

