/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.debug.objectrenderer;

import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetView;
import adams.gui.core.BaseButton;
import adams.gui.dialog.SpreadSheetPanel;
import adams.gui.visualization.debug.objectrenderer.AbstractObjectRenderer;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import nz.ac.waikato.cms.locator.ClassLocator;

public class SpreadSheetRenderer
extends AbstractObjectRenderer {
    private static final long serialVersionUID = -3528006886476495175L;
    public static final int MAX_ROWS = 100;
    protected SpreadSheetPanel m_LastPanel;
    protected Integer m_LastLimit;

    public boolean supportsLimit(Object obj) {
        return true;
    }

    public boolean handles(Class cls) {
        return ClassLocator.hasInterface(SpreadSheet.class, (Class)cls);
    }

    public boolean canRenderCached(Object obj, JPanel panel) {
        return this.m_LastPanel != null;
    }

    protected String doRenderCached(Object obj, JPanel panel, Integer limit) {
        if (this.m_LastLimit != limit) {
            this.m_LastLimit = limit;
            return this.render(obj, panel, limit);
        }
        this.m_LastPanel.setSpreadSheet((SpreadSheet)obj);
        this.m_LastPanel.setShowSearch(true);
        panel.add((Component)this.m_LastPanel, "Center");
        return null;
    }

    protected String doRender(Object obj, JPanel panel, Integer limit) {
        int maxRows = 100;
        if (limit != null) {
            maxRows = limit == -1 ? Integer.MAX_VALUE : limit;
        }
        this.m_LastLimit = limit;
        SpreadSheet sheet = (SpreadSheet)obj;
        if (sheet.getRowCount() >= maxRows) {
            SpreadSheetPanel sheetPanel = new SpreadSheetPanel();
            SpreadSheetView view = new SpreadSheetView(sheet, 0, maxRows);
            sheetPanel.setSpreadSheet((SpreadSheet)view);
            sheetPanel.setShowSearch(true);
            panel.add((Component)sheetPanel, "Center");
            JPanel panelButton = new JPanel(new FlowLayout(0));
            panel.add((Component)panelButton, "South");
            BaseButton buttonAll = new BaseButton("Show all " + sheet.getRowCount() + " rows");
            buttonAll.addActionListener(e -> {
                sheetPanel.setSpreadSheet(sheet);
                panelButton.setVisible(false);
                this.m_LastPanel = sheetPanel;
            });
            panelButton.add((Component)buttonAll);
        } else {
            SpreadSheetPanel sheetPanel = new SpreadSheetPanel();
            sheetPanel.setSpreadSheet(sheet);
            sheetPanel.setShowSearch(true);
            panel.add((Component)sheetPanel, "Center");
            this.m_LastPanel = sheetPanel;
        }
        return null;
    }
}

