/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.jfreechart.dataset;

import adams.core.QuickInfoSupporter;
import adams.core.Utils;
import adams.core.option.AbstractOptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import org.jfree.data.general.Dataset;

public abstract class AbstractDatasetGenerator<T extends Dataset>
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = 125224185085489847L;

    public String getQuickInfo() {
        return null;
    }

    public abstract Class<? extends Dataset> generates();

    protected String check(SpreadSheet data) {
        if (data == null) {
            return "No spreadsheet provided!";
        }
        return null;
    }

    protected abstract T doGenerate(SpreadSheet var1);

    public T generate(SpreadSheet data) {
        String msg = this.check(data);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.doGenerate(data);
    }

    protected String checkAddSeries(Dataset dataset, SpreadSheet data) {
        Object result = this.check(data);
        if (result == null) {
            if (dataset == null) {
                result = "No dataset provided!";
            } else if (!dataset.getClass().equals(this.generates())) {
                result = "Dataset must be of type " + Utils.classToString(this.generates()) + ", not " + Utils.classToString((Object)dataset);
            }
        }
        return result;
    }

    protected abstract T doAddSeries(Dataset var1, SpreadSheet var2);

    public T addSeries(T dataset, SpreadSheet data) {
        String msg = this.checkAddSeries((Dataset)dataset, data);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.doAddSeries((Dataset)dataset, data);
    }
}

