/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.jfreechart.dataset;

import adams.gui.visualization.core.ColorProvider;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.general.SeriesDataset;
import org.jfree.data.xy.DefaultXYDataset;

public class ChartUtils {
    public static final String KEY_DIAGONAL = "$$$Diagonal$$$";

    public static void addDiagonal(DefaultXYDataset dataset, double min, double max) {
        dataset.addSeries((Comparable)((Object)KEY_DIAGONAL), (double[][])new double[][]{{min, max}, {min, max}});
    }

    public static int getDiagonalIndex(SeriesDataset dataset) {
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            if (!dataset.getSeriesKey(i).toString().equals(KEY_DIAGONAL)) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasDiagonal(SeriesDataset dataset) {
        return ChartUtils.getDiagonalIndex(dataset) != -1;
    }

    public static boolean isDiagonal(SeriesDataset dataset, int index) {
        return dataset.getSeriesKey(index).toString().equals(KEY_DIAGONAL);
    }

    public static void applyShape(XYPlot plot, Shape shape) {
        if (shape == null) {
            return;
        }
        for (int i = 0; i < plot.getSeriesCount(); ++i) {
            if (ChartUtils.isDiagonal((SeriesDataset)plot.getDataset(), i)) continue;
            plot.getRenderer().setSeriesShape(i, shape);
        }
    }

    public static void applyColor(XYPlot plot, Color plotColor, Color diagonalColor, ColorProvider colorProvider) {
        int diagonal = ChartUtils.getDiagonalIndex((SeriesDataset)plot.getDataset());
        boolean usePlotColor = plotColor != null && plot.getSeriesCount() == 1 || plot.getSeriesCount() == 2 && diagonal != -1;
        for (int i = 0; i < plot.getSeriesCount(); ++i) {
            if (diagonal == i) {
                plot.getRenderer().setSeriesPaint(i, (Paint)diagonalColor);
                continue;
            }
            if (usePlotColor) {
                plot.getRenderer().setSeriesPaint(i, (Paint)plotColor);
                continue;
            }
            plot.getRenderer().setSeriesPaint(i, (Paint)colorProvider.next());
        }
    }
}

