/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.jfreechart.dataset;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnIndex;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetUtils;
import adams.gui.visualization.jfreechart.dataset.AbstractDatasetGenerator;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;

public class DefaultCategory
extends AbstractDatasetGenerator<DefaultCategoryDataset> {
    private static final long serialVersionUID = -3292751964201246483L;
    protected SpreadSheetColumnIndex m_X;
    protected SpreadSheetColumnRange m_Y;

    public String globalInfo() {
        return "For each of the Y columns, a separate series is generated.\nThe column name is used as name for each series.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)new SpreadSheetColumnIndex("1"));
        this.m_OptionManager.add("y", "Y", (Object)new SpreadSheetColumnRange("2"));
    }

    public void setX(SpreadSheetColumnIndex value) {
        this.m_X = value;
        this.reset();
    }

    public SpreadSheetColumnIndex getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The index of the column in the spreadsheet to use for the X axis.";
    }

    public void setY(SpreadSheetColumnRange value) {
        this.m_Y = value;
        this.reset();
    }

    public SpreadSheetColumnRange getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The columns in the spreadsheet to use for the Y axis/axes.";
    }

    @Override
    public Class<? extends Dataset> generates() {
        return DefaultCategoryDataset.class;
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"X", (Object)((Object)this.m_X), (String)"X: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"Y", (Object)((Object)this.m_Y), (String)", Y: ");
        return result;
    }

    @Override
    protected String check(SpreadSheet data) {
        Object result = super.check(data);
        if (result == null) {
            this.m_X.setData(data);
            if (this.m_X.getIntIndex() == -1) {
                result = "X column not valid? Provided: " + this.m_X;
            }
        }
        if (result == null) {
            this.m_Y.setData(data);
            if (this.m_Y.getIntIndices().length == 0) {
                result = "No Y column(s) available? Provided: " + this.m_Y;
            }
        }
        return result;
    }

    @Override
    protected DefaultCategoryDataset doGenerate(SpreadSheet data) {
        return this.doAddSeries((Dataset)new DefaultCategoryDataset(), data);
    }

    @Override
    protected DefaultCategoryDataset doAddSeries(Dataset dataset, SpreadSheet data) {
        DefaultCategoryDataset result = (DefaultCategoryDataset)dataset;
        this.m_X.setData(data);
        int x = this.m_X.getIntIndex();
        String[] plotX = SpreadSheetUtils.getColumn((SpreadSheet)data, (int)x, (boolean)false, (boolean)false);
        this.m_Y.setData(data);
        int[] y = this.m_Y.getIntIndices();
        for (int i = 0; i < y.length; ++i) {
            String series = data.getColumnName(y[i]);
            double[] plotY = SpreadSheetUtils.getNumericColumn((SpreadSheet)data, (int)y[i]);
            for (int n = 0; n < plotX.length; ++n) {
                result.addValue(plotY[n], (Comparable)((Object)series), (Comparable)((Object)plotX[n]));
            }
        }
        return result;
    }
}

