/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.spreadsheet;

import adams.core.Utils;
import adams.data.container.AbstractDataPoint;
import adams.data.container.DataPoint;
import adams.data.spreadsheet.Cell;
import adams.gui.visualization.spreadsheet.SpreadSheetRow;

public class SpreadSheetRowPoint
extends AbstractDataPoint {
    private static final long serialVersionUID = -8737532674253304044L;
    protected Integer m_X;
    protected Double m_Y;

    public SpreadSheetRowPoint() {
        this(null, null);
    }

    public SpreadSheetRowPoint(Integer x, Double y) {
        this.setX(x);
        this.setY(y);
    }

    public void setX(Integer value) {
        this.m_X = value;
    }

    public Integer getX() {
        return this.m_X;
    }

    public void setY(Double value) {
        this.m_Y = value;
    }

    public Double getY() {
        return this.m_Y;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        int result = 0;
        SpreadSheetRowPoint other = (SpreadSheetRowPoint)((Object)o);
        if (result == 0) {
            result = this.getX().compareTo(other.getX());
        }
        if (result == 0) {
            result = this.getY().compareTo(other.getY());
        }
        return result;
    }

    public void assign(DataPoint other) {
        super.assign(other);
        SpreadSheetRowPoint point = (SpreadSheetRowPoint)other;
        this.setX(point.getX());
        this.setY(point.getY());
    }

    public SpreadSheetRowPoint parse(String s) {
        SpreadSheetRowPoint result = null;
        String[] parts = s.split(",");
        if (parts.length == 3) {
            result = new SpreadSheetRowPoint(Integer.parseInt(parts[1]), Utils.toDouble((String)parts[2]));
        }
        return result;
    }

    public String toString() {
        Object result;
        if (this.getParent() != null) {
            Cell cell = ((SpreadSheetRow)this.getParent()).getDatasetHeader().getHeaderRow().getCell(this.getX().intValue());
            result = cell.getContent();
            result = (String)result + "=";
            result = (String)result + this.getY();
        } else {
            result = this.getX() + "," + this.getY();
        }
        return result;
    }
}

