/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.spreadsheet;

import adams.gui.visualization.core.AxisPanel;
import adams.gui.visualization.core.plot.AbstractDistanceBasedHitDetector;
import adams.gui.visualization.core.plot.Axis;
import adams.gui.visualization.spreadsheet.SpreadSheetRow;
import adams.gui.visualization.spreadsheet.SpreadSheetRowContainer;
import adams.gui.visualization.spreadsheet.SpreadSheetRowContainerManager;
import adams.gui.visualization.spreadsheet.SpreadSheetRowContainerModel;
import adams.gui.visualization.spreadsheet.SpreadSheetRowPanel;
import adams.gui.visualization.spreadsheet.SpreadSheetRowPoint;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public class SpreadSheetRowPointHitDetector
extends AbstractDistanceBasedHitDetector<List<SpreadSheetRowPoint>, String> {
    private static final long serialVersionUID = 3397379783536355060L;
    protected SpreadSheetRowPanel m_Owner;

    public SpreadSheetRowPointHitDetector(SpreadSheetRowPanel owner) {
        this.m_Owner = owner;
    }

    public String globalInfo() {
        return "Detects selections of row points in the row panel.";
    }

    public SpreadSheetRowPanel getOwner() {
        return this.m_Owner;
    }

    protected int[] findEnclosingAttributeIndices(SpreadSheetRow row, double x) {
        int[] result = new int[]{-1, -1};
        if (Math.floor(x) == x) {
            result[0] = (int)x;
        } else {
            result[0] = (int)Math.floor(x);
            result[1] = (int)Math.ceil(x);
        }
        for (int i = 0; i < 2; ++i) {
            if (result[i] >= 0 && result[i] < row.size()) continue;
            result[i] = -1;
        }
        return result;
    }

    protected int findClosestAttributeIndex(SpreadSheetRow row, double x) {
        int result = (int)Math.round(x);
        if (result < 0) {
            result = 0;
        } else if (result > row.size() - 1) {
            result = row.size() - 1;
        }
        return result;
    }

    protected SpreadSheetRowPoint findSpreadSheetRowPoint(SpreadSheetRow inst, int index) {
        SpreadSheetRowPoint result = null;
        List list = inst.toList();
        for (int i = 0; i < list.size(); ++i) {
            if (((SpreadSheetRowPoint)((Object)list.get(i))).getX() != index) continue;
            result = (SpreadSheetRowPoint)((Object)list.get(i));
            break;
        }
        return result;
    }

    protected List<SpreadSheetRowPoint> isHit(MouseEvent e) {
        ArrayList<SpreadSheetRowPoint> result = new ArrayList<SpreadSheetRowPoint>();
        AxisPanel axisBottom = this.m_Owner.getPlot().getAxis(Axis.BOTTOM);
        AxisPanel axisLeft = this.m_Owner.getPlot().getAxis(Axis.LEFT);
        double y = axisLeft.posToValue(e.getY());
        double x = axisBottom.posToValue(e.getX());
        SpreadSheetRowContainerModel model = (SpreadSheetRowContainerModel)this.m_Owner.getContainerList().getContainerModel();
        for (int i = 0; i < model.getRowCount(); ++i) {
            SpreadSheetRowPoint rp;
            if (!((SpreadSheetRowContainer)model.getContainerAt(i)).isVisible()) continue;
            SpreadSheetRow row = ((SpreadSheetRowContainer)model.getContainerAt(i)).getData();
            int[] indices = this.findEnclosingAttributeIndices(row, x);
            if (indices[0] < 0 || indices[1] < 0) {
                int index = this.findClosestAttributeIndex(row, x);
                rp = this.findSpreadSheetRowPoint(row, index);
                if (rp == null) {
                    this.getLogger().info("Failed to determine row point for attribute index #" + index + ": " + row);
                    continue;
                }
                double diffX = (double)rp.getX().intValue() - x;
                int diffPixel = Math.abs(axisBottom.valueToPos(diffX) - axisBottom.valueToPos(0.0));
                this.getLogger().info("diff timestamp=" + diffPixel);
                if (diffPixel > this.m_MinimumPixelDifference) continue;
                double diffY = rp.getY() - y;
                diffPixel = Math.abs(axisLeft.valueToPos(diffY) - axisLeft.valueToPos(0.0));
                this.getLogger().info("diff abundance=" + diffPixel);
                if (diffPixel > this.m_MinimumPixelDifference) continue;
                result.add(rp);
                continue;
            }
            rp = this.findSpreadSheetRowPoint(row, indices[0]);
            if (rp == null) {
                this.getLogger().info("Failed to determine row point for attribute index #" + indices[0] + ": " + row);
                continue;
            }
            SpreadSheetRowPoint rp2 = this.findSpreadSheetRowPoint(row, indices[1]);
            if (rp2 == null) {
                this.getLogger().info("Failed to determine row point for attribute index #" + indices[1] + ": " + row);
                continue;
            }
            double dist = this.distance(new Point2D.Double(axisBottom.valueToPos((double)rp.getX().intValue()), axisLeft.valueToPos(rp.getY().doubleValue())), new Point2D.Double(axisBottom.valueToPos((double)rp2.getX().intValue()), axisLeft.valueToPos(rp2.getY().doubleValue())), new Point2D.Double(e.getX(), e.getY()));
            this.getLogger().info("dist line=" + dist);
            if (dist > (double)this.m_MinimumPixelDifference) continue;
            result.add(rp);
        }
        if (result.size() > 0) {
            return result;
        }
        return null;
    }

    protected String processHit(MouseEvent e, List<SpreadSheetRowPoint> hit) {
        Object result = "";
        for (int i = 0; i < hit.size(); ++i) {
            if (i > 0) {
                result = (String)result + ", ";
            }
            SpreadSheetRow row = (SpreadSheetRow)hit.get(i).getParent();
            SpreadSheetRowContainer cont = ((SpreadSheetRowContainerManager)this.m_Owner.getContainerManager()).newContainer((Comparable)((Object)row));
            result = (String)result + (Object)((Object)hit.get(i)) + " (" + cont.getDisplayID() + ")";
        }
        return result;
    }

    public void cleanUp() {
        this.m_Owner = null;
        super.cleanUp();
    }
}

