/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.spreadsheet.plotpopup;

import adams.data.io.output.SpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.GUIHelper;
import adams.gui.core.ImageManager;
import adams.gui.visualization.container.DataContainerPanelWithContainerList;
import adams.gui.visualization.container.datacontainerpanel.plotpopup.AbstractPlotPopupCustomizer;
import adams.gui.visualization.spreadsheet.SpreadSheetRow;
import adams.gui.visualization.spreadsheet.SpreadSheetRowContainer;
import adams.gui.visualization.spreadsheet.SpreadSheetRowContainerManager;
import adams.gui.visualization.spreadsheet.SpreadSheetRowPanel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class SaveVisible
extends AbstractPlotPopupCustomizer<SpreadSheetRow, SpreadSheetRowContainerManager, SpreadSheetRowContainer> {
    private static final long serialVersionUID = 3295471324320509106L;

    public String getName() {
        return "Save visible";
    }

    public String getGroup() {
        return "export";
    }

    public boolean handles(DataContainerPanelWithContainerList<SpreadSheetRow, SpreadSheetRowContainerManager, SpreadSheetRowContainer> panel) {
        return panel instanceof SpreadSheetRowPanel;
    }

    public void customize(DataContainerPanelWithContainerList<SpreadSheetRow, SpreadSheetRowContainerManager, SpreadSheetRowContainer> panel, MouseEvent e, JPopupMenu menu) {
        JMenuItem item = new JMenuItem("Save visible...", ImageManager.getIcon((String)"save.gif"));
        item.addActionListener(ae -> {
            SpreadSheetFileChooser fc = new SpreadSheetFileChooser();
            int retval = fc.showSaveDialog((Component)panel);
            if (retval != 0) {
                return;
            }
            SpreadSheet sheet = null;
            for (int i = 0; i < ((SpreadSheetRowContainerManager)panel.getContainerManager()).count(); ++i) {
                SpreadSheetRowContainer cont = (SpreadSheetRowContainer)((SpreadSheetRowContainerManager)panel.getContainerManager()).get(i);
                if (i == 0) {
                    sheet = cont.getData().getDatasetHeader().getHeader();
                }
                if (!cont.isVisible()) continue;
                sheet.addRow().assign(cont.getData().toRow());
            }
            if (sheet == null) {
                return;
            }
            SpreadSheetWriter writer = (SpreadSheetWriter)fc.getWriter();
            if (!writer.write(sheet, fc.getSelectedFile())) {
                GUIHelper.showErrorMessage((Component)panel, (String)("Error saving spreadsheet to:\n" + fc.getSelectedFile()));
            }
        });
        menu.add(item);
    }
}

