/*
 * Decompiled with CFR 0.152.
 */
package adams.core.io.console;

import adams.core.base.BasePassword;
import adams.core.io.PlaceholderDirectory;
import adams.core.io.PlaceholderFile;
import adams.core.io.console.Console;
import adams.terminal.dialog.DirectoryDialog;
import adams.terminal.dialog.OptionDialog;
import com.googlecode.lanterna.gui2.MultiWindowTextGUI;
import com.googlecode.lanterna.gui2.TextBox;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.FileDialog;
import com.googlecode.lanterna.gui2.dialogs.TextInputDialog;
import java.io.File;
import java.util.ArrayList;

public class Lanterna
implements Console {
    protected MultiWindowTextGUI m_Context;
    protected TextBox m_TextBoxLog;

    public Lanterna(MultiWindowTextGUI context, TextBox textBoxLog) {
        if (context == null) {
            throw new IllegalArgumentException("Lanterna context cannot be null!");
        }
        this.m_Context = context;
        this.m_TextBoxLog = textBoxLog;
    }

    public String enterMultiLineValue(String msg) {
        return this.enterValue(msg);
    }

    public String enterValue(String msg) {
        return this.enterValue(msg, null);
    }

    public String enterValue(String msg, String initial) {
        if (msg.isEmpty()) {
            msg = "Please enter a value:";
        }
        return TextInputDialog.showDialog((WindowBasedTextGUI)this.m_Context, (String)"Enter value", (String)msg, (String)(initial == null ? "" : initial));
    }

    public String[] enterMultipleValues(String msg) {
        String input;
        ArrayList<String> result = new ArrayList<String>();
        if (msg.isEmpty()) {
            msg = "Please enter one or more values:";
        }
        msg = msg + "\n(empty input will terminate input)";
        do {
            if ((input = this.enterValue(msg)) == null || input.isEmpty()) continue;
            result.add(input);
        } while (input != null && !input.isEmpty());
        if (result.size() > 0) {
            return result.toArray(new String[result.size()]);
        }
        return null;
    }

    public BasePassword enterPassword(String msg) {
        String input;
        BasePassword result = null;
        if (msg.isEmpty()) {
            msg = "Please enter password:";
        }
        if ((input = TextInputDialog.showPasswordDialog((WindowBasedTextGUI)this.m_Context, (String)"Enter password", (String)msg, (String)"")) != null) {
            result = new BasePassword(input);
        }
        return result;
    }

    public String selectOption(String msg, String[] options) {
        return this.selectOption(msg, options, null);
    }

    public String selectOption(String msg, String[] options, String initial) {
        if (initial == null) {
            initial = "";
        }
        if (msg.isEmpty()) {
            msg = "Please select an option:";
        }
        return OptionDialog.showDialog((WindowBasedTextGUI)this.m_Context, "Select option", msg, options, initial);
    }

    public PlaceholderDirectory selectDirectory(String msg, PlaceholderDirectory initial) {
        DirectoryDialog dialog = new DirectoryDialog("Select directory", msg, "Select", this.m_Context.getScreen().getTerminalSize(), false, initial.getAbsoluteFile());
        File result = dialog.showDialog((WindowBasedTextGUI)this.m_Context);
        if (result == null) {
            return null;
        }
        return new PlaceholderDirectory(result);
    }

    public PlaceholderFile[] selectFiles(String msg, PlaceholderFile ... initial) {
        File file;
        ArrayList<PlaceholderFile> result = new ArrayList<PlaceholderFile>();
        do {
            FileDialog dialog;
            if ((file = (dialog = new FileDialog("Select file", msg, "Select", this.m_Context.getScreen().getTerminalSize(), false, null)).showDialog((WindowBasedTextGUI)this.m_Context)) == null) continue;
            result.add(new PlaceholderFile(file));
        } while (file != null);
        if (result.size() == 0) {
            return null;
        }
        return result.toArray(new PlaceholderFile[result.size()]);
    }

    public void printlnOut(String msg) {
        if (this.m_TextBoxLog != null) {
            this.m_TextBoxLog.addLine(msg);
            this.m_TextBoxLog.setCaretPosition(this.m_TextBoxLog.getLineCount(), 0);
        } else {
            System.out.println(msg);
        }
    }

    public void printlnErr(String msg) {
        if (this.m_TextBoxLog != null) {
            this.m_TextBoxLog.addLine(msg);
            this.m_TextBoxLog.setCaretPosition(this.m_TextBoxLog.getLineCount(), 0);
        } else {
            System.err.println(msg);
        }
    }
}

