/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal;

import adams.core.logging.AbstractLogHandler;
import adams.core.logging.LoggingHelper;
import adams.core.logging.MultiHandler;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.env.Environment;
import adams.terminal.application.AbstractLanternaTerminalApplication;
import adams.terminal.application.ApplicationMenu;
import adams.terminal.core.LogTextBox;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.BasicWindow;
import com.googlecode.lanterna.gui2.BorderLayout;
import com.googlecode.lanterna.gui2.Borders;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.Direction;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LinearLayout;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import java.util.Arrays;
import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class Main
extends AbstractLanternaTerminalApplication {
    private static final long serialVersionUID = -6680605754144851435L;
    protected Panel m_PanelMain;
    protected Panel m_MenuBar;
    protected LogTextBox m_TextBoxLog;
    protected Button m_ButtonClear;

    public String globalInfo() {
        return "ADAMS Application";
    }

    @Override
    protected void initTerminal() {
        super.initTerminal();
        this.m_MainWindow = new BasicWindow();
        this.m_MainWindow.setHints(Arrays.asList(Window.Hint.FULL_SCREEN));
        this.m_PanelMain = new Panel((LayoutManager)new BorderLayout());
        ApplicationMenu menu = new ApplicationMenu(this);
        this.m_MenuBar = menu.getMenuBar((WindowBasedTextGUI)this.m_GUI);
        this.m_PanelMain.addComponent((Component)this.m_MenuBar, (LayoutData)BorderLayout.Location.TOP);
        Panel panel = new Panel((LayoutManager)new BorderLayout());
        this.m_PanelMain.addComponent((Component)panel, (LayoutData)BorderLayout.Location.CENTER);
        panel.addComponent((Component)new EmptySpace(), (LayoutData)BorderLayout.Location.TOP);
        this.m_TextBoxLog = new LogTextBox(new TerminalSize(40, 10));
        panel.addComponent((Component)this.m_TextBoxLog.withBorder(Borders.singleLine((String)"Log")), (LayoutData)BorderLayout.Location.CENTER);
        Panel panelButtons = new Panel((LayoutManager)new LinearLayout(Direction.HORIZONTAL));
        panel.addComponent((Component)panelButtons, (LayoutData)BorderLayout.Location.BOTTOM);
        this.m_ButtonClear = new Button("Clear", () -> this.m_TextBoxLog.clear());
        panelButtons.addComponent((Component)this.m_ButtonClear);
    }

    protected String getDefaultApplicationTitle() {
        return "ADAMS";
    }

    protected void setTitle(String value) {
        if (this.m_MenuBar != null) {
            this.m_MainWindow.setComponent((Component)this.m_PanelMain.withBorder(Borders.singleLine((String)value)));
        }
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    @Override
    public LogTextBox getLogTextBox() {
        return this.m_TextBoxLog;
    }

    protected Handler createLogHandler() {
        MultiHandler result = new MultiHandler();
        result.setHandlers(new Handler[]{new LogHandler(this)});
        return result;
    }

    public void appendLog(String msg) {
        this.m_TextBoxLog.addLine(msg);
        this.m_TextBoxLog.setCaretPosition(this.m_TextBoxLog.getLineCount(), 0);
    }

    public static void main(String[] args) throws Exception {
        Main.runApplication(Environment.class, Main.class, (String[])args);
        System.exit(0);
    }

    public static class LogHandler
    extends AbstractLogHandler {
        protected Main m_Owner;

        public LogHandler(Main owner) {
            this.m_Owner = owner;
        }

        protected void doPublish(LogRecord record) {
            this.m_Owner.appendLog(LoggingHelper.assembleMessage((LogRecord)record).toString());
        }
    }
}

