/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.application;

import adams.core.io.ConsoleHelper;
import adams.core.io.console.Console;
import adams.core.io.console.Lanterna;
import adams.core.logging.LoggingHelper;
import adams.core.option.OptionUtils;
import adams.gui.application.AbstractInitialization;
import adams.scripting.engine.RemoteScriptingEngine;
import adams.terminal.application.AbstractTerminalApplication;
import adams.terminal.core.LogTextBox;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.DefaultWindowManager;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.MultiWindowTextGUI;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowManager;
import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.screen.TerminalScreen;
import com.googlecode.lanterna.terminal.DefaultTerminalFactory;
import com.googlecode.lanterna.terminal.Terminal;
import java.util.logging.Handler;
import java.util.logging.Level;

public abstract class AbstractLanternaTerminalApplication
extends AbstractTerminalApplication {
    private static final long serialVersionUID = 2187425015130568365L;
    protected Terminal m_Terminal;
    protected Screen m_Screen;
    protected MultiWindowTextGUI m_GUI;
    protected Window m_MainWindow;

    protected AbstractLanternaTerminalApplication() {
    }

    protected void initialize() {
        super.initialize();
        this.m_MainWindow = null;
    }

    protected void initTerminal() {
        try {
            DefaultTerminalFactory factory = new DefaultTerminalFactory();
            factory.setTerminalEmulatorTitle(this.getDefaultApplicationTitle());
            this.m_Terminal = factory.createTerminal();
            this.m_Screen = new TerminalScreen(this.m_Terminal);
            this.m_Screen.startScreen();
            this.m_GUI = new MultiWindowTextGUI(this.m_Screen, (WindowManager)new DefaultWindowManager(), (Component)new EmptySpace((TextColor)TextColor.ANSI.BLUE));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public LogTextBox getLogTextBox() {
        return null;
    }

    public void logMessage(String msg) {
        if (this.getLogTextBox() != null) {
            this.getLogTextBox().addLine(msg);
        } else {
            System.out.println(msg);
        }
    }

    public void logError(String msg) {
        if (this.getLogTextBox() != null) {
            this.getLogTextBox().addLine(msg);
        } else {
            System.err.println(msg);
        }
    }

    public void logError(String msg, Throwable t) {
        if (this.getLogTextBox() != null) {
            this.getLogTextBox().addLine(msg + "\n" + LoggingHelper.throwableToString((Throwable)t));
        } else {
            System.err.println(msg + "\n" + LoggingHelper.throwableToString((Throwable)t));
        }
    }

    protected void finishTerminal() {
        AbstractInitialization.initAll();
        ConsoleHelper.useOther((Console)new Lanterna(this.m_GUI, this.getLogTextBox()));
        LoggingHelper.setDefaultHandler((Handler)this.createLogHandler());
        if (!this.m_RemoteScriptingEngineCmdLine.isEmpty()) {
            RemoteScriptingEngine engine;
            try {
                engine = (RemoteScriptingEngine)OptionUtils.forAnyCommandLine(RemoteScriptingEngine.class, (String)this.m_RemoteScriptingEngineCmdLine);
            }
            catch (Exception e) {
                engine = null;
                this.getLogger().log(Level.SEVERE, "Failed to instantiate remote scripting engine from commandline: '" + this.m_RemoteScriptingEngineCmdLine + "'", (Throwable)e);
            }
            if (engine != null) {
                this.setRemoteScriptingEngine(engine);
            }
        }
    }

    public void start() {
        if (this.m_MainWindow != null) {
            this.createTitle("");
            this.m_GUI.addWindowAndWait(this.m_MainWindow);
        }
    }

    public void stop() {
        try {
            if (this.m_MainWindow != null) {
                this.m_MainWindow.close();
            }
            this.m_Screen.stopScreen();
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to stop screen!", (Throwable)e);
        }
    }
}

