/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.core;

import adams.terminal.core.MenuListDialogBuilder;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.ActionListBox;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LocalizedString;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.DialogWindow;
import java.util.List;

public class MenuListDialog
extends DialogWindow {
    MenuListDialog(String title, String description, TerminalSize actionListPreferredSize, List<Runnable> actions) {
        super(title);
        if (actions.isEmpty()) {
            throw new IllegalStateException("MenuListDialog needs at least one item");
        }
        ActionListBox listBox = new ActionListBox(actionListPreferredSize);
        for (final Runnable action : actions) {
            listBox.addItem(action.toString(), new Runnable(){

                @Override
                public void run() {
                    action.run();
                    MenuListDialog.this.close();
                }
            });
        }
        Panel mainPanel = new Panel();
        mainPanel.setLayoutManager((LayoutManager)new GridLayout(1).setLeftMarginSize(1).setRightMarginSize(1));
        if (description != null) {
            mainPanel.addComponent((Component)new Label(description));
            mainPanel.addComponent((Component)new EmptySpace(TerminalSize.ONE));
        }
        ((ActionListBox)listBox.setLayoutData(GridLayout.createLayoutData((GridLayout.Alignment)GridLayout.Alignment.FILL, (GridLayout.Alignment)GridLayout.Alignment.CENTER, (boolean)true, (boolean)false))).addTo(mainPanel);
        mainPanel.addComponent((Component)new EmptySpace(TerminalSize.ONE));
        Panel buttonPanel = new Panel();
        buttonPanel.setLayoutManager((LayoutManager)new GridLayout(2).setHorizontalSpacing(1));
        buttonPanel.addComponent(new Button(LocalizedString.Close.toString(), new Runnable(){

            @Override
            public void run() {
                MenuListDialog.this.onClose();
            }
        }).setLayoutData(GridLayout.createLayoutData((GridLayout.Alignment)GridLayout.Alignment.CENTER, (GridLayout.Alignment)GridLayout.Alignment.CENTER, (boolean)true, (boolean)false)));
        ((Panel)buttonPanel.setLayoutData(GridLayout.createLayoutData((GridLayout.Alignment)GridLayout.Alignment.END, (GridLayout.Alignment)GridLayout.Alignment.CENTER, (boolean)false, (boolean)false))).addTo(mainPanel);
        this.setComponent((Component)mainPanel);
    }

    private void onClose() {
        this.close();
    }

    public static void showDialog(WindowBasedTextGUI textGUI, String title, String description, Runnable ... items) {
        MenuListDialog actionListDialog = (MenuListDialog)((MenuListDialogBuilder)((Object)((MenuListDialogBuilder)((Object)new MenuListDialogBuilder().setTitle(title))).setDescription(description))).addActions(items).build();
        actionListDialog.showDialog(textGUI);
    }
}

