/*
 * Decompiled with CFR 0.152.
 */
package adams.terminal.dialog;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.BorderLayout;
import com.googlecode.lanterna.gui2.Button;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.GridLayout;
import com.googlecode.lanterna.gui2.Label;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import com.googlecode.lanterna.gui2.LocalizedString;
import com.googlecode.lanterna.gui2.Panel;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.dialogs.DialogWindow;
import com.googlecode.lanterna.gui2.dialogs.MessageDialogButton;
import java.util.ArrayList;
import java.util.Collection;

public class ComponentDialog
extends DialogWindow {
    protected Component component;
    protected MessageDialogButton result;

    public ComponentDialog(String title, String description, Component component) {
        this(title, description, component, new ArrayList<Window.Hint>());
    }

    public ComponentDialog(String title, String description, Component component, boolean hasOK, boolean hasCancel, boolean hasClose) {
        this(title, description, component, new ArrayList<Window.Hint>(), hasOK, hasCancel, hasClose);
    }

    public ComponentDialog(String title, String description, Component component, Collection<Window.Hint> hints) {
        this(title, description, component, hints, true, true, false);
    }

    public ComponentDialog(String title, String description, Component component, Collection<Window.Hint> hints, boolean hasOK, boolean hasCancel, boolean hasClose) {
        super(title);
        Panel panelButtons = new Panel((LayoutManager)new GridLayout(2));
        panelButtons.setLayoutData(GridLayout.createLayoutData((GridLayout.Alignment)GridLayout.Alignment.END, (GridLayout.Alignment)GridLayout.Alignment.CENTER, (boolean)true, (boolean)false, (int)2, (int)1));
        if (hasOK) {
            panelButtons.addComponent((Component)new Button(LocalizedString.OK.toString(), () -> this.onOK()));
        }
        if (hasCancel) {
            panelButtons.addComponent((Component)new Button(LocalizedString.Cancel.toString(), () -> this.onCancel()));
        }
        if (hasClose) {
            panelButtons.addComponent((Component)new Button(LocalizedString.Close.toString(), () -> this.onClose()));
        }
        Panel contentPanel = new Panel();
        contentPanel.setLayoutManager((LayoutManager)new BorderLayout());
        if (description != null) {
            contentPanel.addComponent((Component)new Label(description), (LayoutData)BorderLayout.Location.TOP);
        }
        this.setHints(hints);
        contentPanel.addComponent(component, (LayoutData)BorderLayout.Location.CENTER);
        contentPanel.addComponent((Component)panelButtons, (LayoutData)BorderLayout.Location.BOTTOM);
        this.setComponent((Component)contentPanel);
    }

    public void setSize(WindowBasedTextGUI textGUI, double width, double height) {
        int actWidth = width <= 1.0 ? (int)((double)textGUI.getScreen().getTerminalSize().getColumns() * width) : (int)width;
        int actHeight = height <= 1.0 ? (int)((double)textGUI.getScreen().getTerminalSize().getRows() * height) : (int)height;
        this.setSize(new TerminalSize(actWidth, actHeight));
    }

    protected void onOK() {
        this.result = MessageDialogButton.OK;
        this.close();
    }

    protected void onCancel() {
        this.result = MessageDialogButton.Cancel;
        this.close();
    }

    protected void onClose() {
        this.result = MessageDialogButton.Close;
        this.close();
    }

    public MessageDialogButton showDialog(WindowBasedTextGUI textGUI) {
        this.result = MessageDialogButton.Cancel;
        super.showDialog(textGUI);
        return this.result;
    }

    public MessageDialogButton getResult() {
        return this.result;
    }

    public static MessageDialogButton showDialog(WindowBasedTextGUI textGUI, String title, String description, Component component) {
        return ComponentDialog.showDialog(textGUI, title, description, component, new ArrayList<Window.Hint>());
    }

    public static MessageDialogButton showDialog(WindowBasedTextGUI textGUI, String title, String description, Component component, Collection<Window.Hint> hints) {
        return ComponentDialog.showDialog(textGUI, title, description, component, hints, true, true, false);
    }

    public static MessageDialogButton showDialog(WindowBasedTextGUI textGUI, String title, String description, Component component, boolean hasOK, boolean hasCancel, boolean hasClose) {
        return ComponentDialog.showDialog(textGUI, title, description, component, new ArrayList<Window.Hint>(), hasOK, hasCancel, hasClose);
    }

    public static MessageDialogButton showDialog(WindowBasedTextGUI textGUI, String title, String description, Component component, Collection<Window.Hint> hints, boolean hasOK, boolean hasCancel, boolean hasClose) {
        if (!hints.contains(Window.Hint.FIXED_POSITION)) {
            hints = new ArrayList<Window.Hint>(hints);
            hints.add(Window.Hint.CENTERED);
        }
        ComponentDialog dialog = new ComponentDialog(title, description, component, hints, hasOK, hasCancel, hasClose);
        return dialog.showDialog(textGUI);
    }
}

